/*
 * Decompiled with CFR 0.152.
 */
package com.ScienceActive.ctmcp.validate;

import com.ScienceActive.SATuner.net.SATunerAnswer;
import com.ScienceActive.SATuner.net.SATunerConnection;
import com.ScienceActive.SATuner.net.SATunerRequest;
import com.ScienceActive.ctmcp.validate.ValidationDialog;
import gnu.getopt.Getopt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import javax.swing.JOptionPane;

public class Validate {
    private final String TUNER_SERVLET_URL = "http://www.scienceactive.com/v3/servlet/SATunerServlet";
    private static final int OPTION_WRONG = 0;
    private static final int OPTION_INIT = 1;
    private static final int OPTION_VALIDATE = 2;
    private static final int OPTION_DELETE = 3;
    private boolean[] options = null;
    public static String PROP_USER = "user";
    public static String PROP_EMAIL = "email";
    public static String PROP_CODEVALID = "codevalid";
    public static String PROP_CODECONFIRM = "codeconfirm";
    public static String PROP_CODEDATE = "codedate";
    public static String PROP_NETWORK = "network";
    public static String PROP_NBCOPIES = "nbCopies";
    public static String PROP_PSEUDO = "pseudo";
    public static String PROP_PWD = "password";
    private static final String ERROR_BADPROPS = "Impossible d'acc\u00e9der aux informations de validation.";
    private static final String MSG_NOTALLOWED = "La validation de votre installation a \u00e9t\u00e9 refus\u00e9e. V\u00e9rifiez que vous n'avez pas install\u00e9 toutes les copies disponibles.";
    private static final String MSG_NONETWORK = "Le serveur de validation n'a pas pu \u00eatre contact\u00e9. V\u00e9rifiez votre connexion Internet et renouvelez l'op\u00e9ration.";
    private static final String MSG_NOCONFIRM = "Le code de confirmation n'est pas valide.";
    private static String VALIDATE_FILENAME = "validate.ini";
    private static String CONFIG_FILENAME = "config.ini";
    Properties propsValidate = null;
    Properties propsConfig = null;

    public Validate(boolean[] opts) {
        this.options = opts;
    }

    public void doIt() {
        if (this.options[1]) {
            this.initValidation();
        } else if (this.options[2]) {
            this.doValidation();
        }
        System.exit(0);
    }

    private void deleteConfigValidate() {
        File conf = new File(VALIDATE_FILENAME);
        conf.delete();
    }

    private boolean readValidateConfig() {
        File conf = new File(VALIDATE_FILENAME);
        if (!conf.exists()) {
            this.propsValidate = new Properties();
            this.propsValidate.setProperty(PROP_USER, "");
            this.propsValidate.setProperty(PROP_EMAIL, "");
            this.propsValidate.setProperty(PROP_CODEVALID, "");
            this.propsValidate.setProperty(PROP_PSEUDO, "");
            this.propsValidate.setProperty(PROP_PWD, "");
            this.propsValidate.setProperty(PROP_NETWORK, "");
        } else {
            try {
                FileInputStream fis = new FileInputStream(conf);
                this.propsValidate = new Properties();
                this.propsValidate.load(fis);
                fis.close();
            }
            catch (Exception e) {
                this.propsValidate = null;
                return false;
            }
        }
        return true;
    }

    private String crypt(String key) {
        byte[] uniqueKey = key.getBytes();
        byte[] hash = null;
        try {
            hash = MessageDigest.getInstance("MD5").digest(uniqueKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("no MD5 support in this VM");
        }
        StringBuffer hashString = new StringBuffer();
        int i = 0;
        while (i < hash.length) {
            String hex = Integer.toHexString(hash[i]);
            if (hex.length() == 1) {
                hashString.append('0');
                hashString.append(hex.charAt(hex.length() - 1));
            } else {
                hashString.append(hex.substring(hex.length() - 2));
            }
            ++i;
        }
        return hashString.toString();
    }

    private void saveValidateConfig() {
        try {
            Properties tmpProps = this.propsValidate;
            tmpProps.setProperty(PROP_PWD, this.crypt(tmpProps.getProperty(PROP_PWD)));
            tmpProps.setProperty(PROP_PSEUDO, this.crypt(tmpProps.getProperty(PROP_PSEUDO)));
            File conf = new File(VALIDATE_FILENAME);
            FileOutputStream fos = new FileOutputStream(conf);
            tmpProps.store(fos, null);
            fos.close();
        }
        catch (Exception e) {
            this.propsValidate = null;
            e.printStackTrace();
        }
    }

    private void writeConfig() {
        try {
            File conf = new File(CONFIG_FILENAME);
            FileOutputStream fos = new FileOutputStream(conf);
            this.propsConfig.store(fos, null);
            fos.close();
        }
        catch (Exception e) {
            this.propsConfig = null;
            e.printStackTrace();
        }
    }

    private boolean initValidation() {
        if (!this.readValidateConfig()) {
            JOptionPane.showMessageDialog(null, ERROR_BADPROPS, "Erreur", 0);
            return false;
        }
        ValidationDialog vd = new ValidationDialog(this.propsValidate);
        vd.setVisible(true);
        if (!vd.isValidated()) {
            return false;
        }
        this.saveValidateConfig();
        return true;
    }

    private String hostToLong(String hostname) {
        return Long.toString(Math.abs(hostname.hashCode()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doValidation() {
        if (!this.readValidateConfig()) {
            System.err.println("validate: Impossible d'acc\u00e9der aux informations de validation.");
            return false;
        }
        try {
            this.propsConfig = new Properties();
            this.propsConfig.setProperty(PROP_USER, this.propsValidate.getProperty(PROP_USER));
            this.propsConfig.setProperty(PROP_EMAIL, this.propsValidate.getProperty(PROP_EMAIL));
            this.propsConfig.setProperty(PROP_CODEVALID, this.propsValidate.getProperty(PROP_CODEVALID));
            this.propsConfig.setProperty(PROP_NETWORK, this.propsValidate.getProperty(PROP_NETWORK));
            this.propsConfig.setProperty(PROP_NBCOPIES, this.propsValidate.getProperty(PROP_NBCOPIES));
            InetAddress local = InetAddress.getLocalHost();
            String hostname = local.getHostName();
            SATunerRequest request = new SATunerRequest(9);
            request.putArg(PROP_USER, this.propsConfig.getProperty(PROP_USER));
            request.putArg(PROP_EMAIL, this.propsConfig.getProperty(PROP_EMAIL));
            request.putArg(PROP_CODEVALID, this.propsConfig.getProperty(PROP_CODEVALID));
            request.putArg(PROP_NETWORK, this.propsValidate.getProperty(PROP_NETWORK));
            request.putArg(PROP_NBCOPIES, this.propsValidate.getProperty(PROP_NBCOPIES));
            request.putArg("ipaddress", local.getHostAddress());
            request.putArg("hostname", local.getHostName());
            request.putArg(PROP_PSEUDO, this.propsValidate.getProperty(PROP_PSEUDO));
            request.putArg(PROP_PWD, this.propsValidate.getProperty(PROP_PWD));
            long nbCopiesValue = Long.parseLong(this.propsValidate.getProperty(PROP_NBCOPIES));
            if (nbCopiesValue == 1L) {
                this.propsConfig.setProperty(PROP_CODEDATE, this.hostToLong(hostname));
            } else {
                this.propsConfig.setProperty(PROP_CODEDATE, this.hostToLong(String.valueOf(this.propsValidate.getProperty(PROP_NETWORK)) + this.propsValidate.getProperty(PROP_CODEVALID)));
            }
            request.putArg(PROP_CODEDATE, this.propsConfig.getProperty(PROP_CODEDATE));
            SATunerConnection conn = new SATunerConnection("http://www.scienceactive.com/v3/servlet/SATunerServlet");
            SATunerAnswer answer = conn.send(request);
            switch (answer.getStatus()) {
                case 1: {
                    this.propsConfig.setProperty(PROP_CODECONFIRM, (String)answer.getAnswer());
                    break;
                }
                case 2: {
                    System.err.println("validate: La validation de votre installation a \u00e9t\u00e9 refus\u00e9e. V\u00e9rifiez que vous n'avez pas install\u00e9 toutes les copies disponibles. (" + (String)answer.getAnswer() + ")");
                    return false;
                }
                case 4: {
                    System.err.println("validate: Le serveur de validation n'a pas pu \u00eatre contact\u00e9. V\u00e9rifiez votre connexion Internet et renouvelez l'op\u00e9ration. (" + (String)answer.getAnswer() + ")");
                    return false;
                }
                default: {
                    System.err.println("validate: Le serveur de validation n'a pas pu \u00eatre contact\u00e9. V\u00e9rifiez votre connexion Internet et renouvelez l'op\u00e9ration. (" + (String)answer.getAnswer() + ")");
                    return false;
                }
            }
            request = new SATunerRequest(8);
            request.putArg(PROP_CODECONFIRM, this.propsConfig.getProperty(PROP_CODECONFIRM));
            answer = conn.send(request);
            switch (answer.getStatus()) {
                case 1: {
                    break;
                }
                case 2: {
                    System.err.println("validate: Le code de confirmation n'est pas valide. (" + (String)answer.getAnswer() + ")");
                    return false;
                }
                case 4: {
                    System.err.println("validate: Le serveur de validation n'a pas pu \u00eatre contact\u00e9. V\u00e9rifiez votre connexion Internet et renouvelez l'op\u00e9ration. (" + (String)answer.getAnswer() + ")");
                    return false;
                }
                default: {
                    System.err.println("validate: Le serveur de validation n'a pas pu \u00eatre contact\u00e9. V\u00e9rifiez votre connexion Internet et renouvelez l'op\u00e9ration. (" + (String)answer.getAnswer() + ")");
                    return false;
                }
            }
            this.writeConfig();
            if (this.options[3]) {
                this.deleteConfigValidate();
            }
            System.out.println("validate: validation termin\u00e9e");
            return true;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void usage() {
        System.err.println("");
        System.err.println("Usage : validate [-i] [-v [-s]]");
        System.err.println("");
        System.err.println("    liste des options :");
        System.err.println("        -i\tinitialiser la configuration de la validation");
        System.err.println("        -v\tproc\u00e9der \u00e0 la validation");
        System.err.println("        -s\tsupprimer la configuration apr\u00e8s la validation");
        System.err.println("");
        System.exit(0);
    }

    public static void main(String[] args) {
        int c;
        if (args == null || args.length == 0) {
            Validate.usage();
        }
        Getopt g = new Getopt("validate", args, ":ivs");
        boolean[] options = new boolean[4];
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 105: {
                    options[1] = true;
                    break;
                }
                case 118: {
                    options[2] = true;
                    break;
                }
                case 115: {
                    options[3] = true;
                    break;
                }
                default: {
                    options[0] = true;
                }
            }
        }
        if (options[0]) {
            Validate.usage();
        }
        if (options[1] && (options[2] || options[3])) {
            System.err.println("validate: -i ne doit pas peut \u00eatre combin\u00e9e \u00e0 une autre option");
            Validate.usage();
        }
        if (!options[2] && options[3]) {
            System.err.println("validate: -s doit \u00eatre combin\u00e9e avec -v");
            Validate.usage();
        }
        Validate validate = new Validate(options);
        validate.doIt();
    }
}

