/*
 * Decompiled with CFR 0.152.
 */
package com.ScienceActive.ctmcp.applet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public class Config {
    private static String CONFIG_FILENAME = "config.ini";
    public static String PROP_USER = "user";
    public static String PROP_EMAIL = "email";
    public static String PROP_CODEVALID = "codevalid";
    public static String PROP_CODECONFIRM = "codeconfirm";
    public static String PROP_CODEDATE = "codedate";
    public static String PROP_OZPATH = "ozpath";
    public static String PROP_OZNAME = "ozname";
    public static String PROP_NETWORK = "network";
    public static String PROP_NBCOPIES = "nbCopies";
    private String path = null;
    private Properties props = null;

    public Config(String path) {
        this.path = path;
        if (!this.path.endsWith(File.separator)) {
            this.path = String.valueOf(this.path) + File.separator;
        }
        this.props = new Properties();
        this.props.setProperty(PROP_USER, "");
        this.props.setProperty(PROP_EMAIL, "");
        this.props.setProperty(PROP_CODEVALID, "");
        this.props.setProperty(PROP_CODEDATE, "");
        this.props.setProperty(PROP_CODECONFIRM, "");
        this.props.setProperty(PROP_OZPATH, "");
        this.props.setProperty(PROP_OZNAME, "");
        this.props.setProperty(PROP_NBCOPIES, "");
        this.props.setProperty(PROP_NETWORK, "");
    }

    public void load() {
        File conf = new File(String.valueOf(this.path) + CONFIG_FILENAME);
        if (!conf.exists()) {
            this.save();
        }
        try {
            FileInputStream fis = new FileInputStream(conf);
            this.props = new Properties();
            this.props.load(fis);
            fis.close();
        }
        catch (Exception e) {
            this.props = null;
        }
    }

    public void save() {
        try {
            File conf = new File(String.valueOf(this.path) + CONFIG_FILENAME);
            FileOutputStream fos = new FileOutputStream(conf);
            this.props.store(fos, null);
            fos.close();
        }
        catch (Exception e) {
            this.props = null;
            e.printStackTrace();
        }
    }

    public String get(String propName) {
        String tmp = this.props.getProperty(propName);
        return tmp == null ? "" : tmp;
    }

    public void set(String propName, String value) {
        if (value == null) {
            this.props.setProperty(propName, "");
        } else {
            this.props.setProperty(propName, value);
        }
    }
}

