/*
 * Decompiled with CFR 0.152.
 */
package com.ScienceActive.ctmcp.applet;

import com.ScienceActive.ctmcp.applet.Config;
import com.ScienceActive.ctmcp.applet.Validation;
import com.ScienceActive.ctmcp.applet.opi.OzBrowserListener;
import com.ScienceActive.ctmcp.applet.opi.OzMessage;
import com.ScienceActive.ctmcp.applet.opi.OzStub;
import java.io.File;
import java.net.URI;
import javax.swing.JApplet;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class CookbookApplet
extends JApplet {
    private static final long serialVersionUID = -421717706859810386L;
    private static final String OZ_READY_MSG = "Oz est pr\u00eat";
    private static final String OZ_NOTREADY_MSG = "Oz n'est pas pr\u00eat";
    private OzStub ozStub = null;
    private Validation valid = null;
    private Config config = null;
    private String ozName = null;
    private String ozPath = null;
    private String laboPath = null;
    private OzBrowserListener ozBrowser = null;

    public void init() {
        super.init();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.initLabo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void start() {
        super.start();
        try {
            this.startLabo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        super.stop();
        this.stopOz();
    }

    public void destroy() {
        super.destroy();
    }

    public void clear() {
        if (this.ozStub == null) {
            System.err.println("Oz isn't ready !!");
        } else {
            this.ozStub.clear();
        }
    }

    private void initLabo() throws Exception {
        File f = new File(new URI(this.getCodeBase().toExternalForm()));
        this.laboPath = f.getAbsolutePath();
        this.config = new Config(this.laboPath);
        this.config.load();
        boolean found = false;
        File ozdir = new File(this.config.get(Config.PROP_OZPATH));
        String ozFileName = this.containsOz(ozdir, this.config.get(Config.PROP_OZNAME));
        boolean bl = found = ozFileName != null;
        if (!found) {
            String pathVar = System.getenv("PATH");
            String[] paths = pathVar.split(File.pathSeparator);
            int i = 0;
            while (i < paths.length && !found) {
                ozdir = new File(paths[i]);
                ozFileName = this.containsOz(ozdir, null);
                found = ozFileName != null;
                ++i;
            }
            if (found) {
                this.config.set(Config.PROP_OZPATH, ozdir.getAbsolutePath());
                this.config.set(Config.PROP_OZNAME, ozFileName);
                this.config.save();
            }
        }
        if (!found) {
            JOptionPane.showMessageDialog(null, "Le syst\u00e8me Mozart n'a pas \u00e9t\u00e9 trouv\u00e9 sur votre machine. Veuillez\nindiquer son fichier ex\u00e9cutable dans la fen\u00eatre suivante.", "Erreur", 0);
            JFileChooser chooser = new JFileChooser();
            boolean done = false;
            do {
                int returnVal;
                if ((returnVal = chooser.showOpenDialog(null)) == 0) {
                    ozdir = chooser.getSelectedFile();
                    this.config.set(Config.PROP_OZPATH, ozdir.getParent());
                    this.config.set(Config.PROP_OZNAME, ozdir.getName());
                    this.config.save();
                    found = true;
                    continue;
                }
                if (returnVal != 1) continue;
                done = true;
            } while (!found && !done);
        }
        this.ozPath = null;
        this.ozName = null;
        if (!found) {
            System.out.println("OZ n'a pas \u00e9t\u00e9 trouv\u00e9");
        } else {
            this.ozPath = this.config.get(Config.PROP_OZPATH);
            this.ozName = this.config.get(Config.PROP_OZNAME);
        }
    }

    private void startLabo() throws Exception {
        this.ozStub = new OzStub(false);
        this.ozBrowser = new OzBrowserListener(this);
        this.ozStub.addListener(this.ozBrowser);
        this.startOz();
    }

    private String containsOz(File dir, String fileName) {
        String prefix = "ozengine";
        if (fileName != null) {
            prefix = fileName;
        }
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            int j = 0;
            while (j < files.length) {
                File tmpFile = files[j];
                if (tmpFile.isFile() && tmpFile.getName().startsWith(prefix)) {
                    return tmpFile.getName();
                }
                ++j;
            }
        }
        return null;
    }

    public void startOz() {
        if (this.ozStub == null) {
            System.err.println(OZ_NOTREADY_MSG);
            return;
        }
        this.ozStub.startup(this.ozName, this.ozPath, this.laboPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopOz() {
        if (this.ozStub == null) {
            System.err.println(OZ_NOTREADY_MSG);
            return;
        }
        this.ozStub.shutdown();
        try {
            CookbookApplet cookbookApplet = this;
            synchronized (cookbookApplet) {
                this.wait(10L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ozStub = null;
    }

    public void restartOz() {
        if (this.ozStub == null) {
            System.err.println(OZ_NOTREADY_MSG);
        } else {
            this.ozStub.restart();
        }
    }

    public void hello() {
        if (this.ozStub == null) {
            System.err.println(OZ_NOTREADY_MSG);
        } else {
            this.execute("{Browse 'Oz est pr\u00eat'}", true);
        }
    }

    public void askBrowse(String strId) {
        if (this.ozStub == null) {
            System.err.println(OZ_NOTREADY_MSG);
            return;
        }
        this.ozStub.send(new OzMessage(new OzMessage[]{new OzMessage("askBrowse"), new OzMessage(strId)}));
    }

    public void execute(String strCode, boolean clear) {
        if (this.ozStub == null) {
            System.err.println(OZ_NOTREADY_MSG);
            return;
        }
        if (clear) {
            this.clear();
        }
        this.ozStub.send(new OzMessage(new OzMessage[]{new OzMessage("feed"), new OzMessage(strCode)}));
    }

    public void openOzPanel() {
        if (this.ozStub == null) {
            System.err.println(OZ_NOTREADY_MSG);
            return;
        }
        this.ozStub.send(new OzMessage(new OzMessage[]{new OzMessage("panel"), new OzMessage("open")}));
    }

    public void openFile() {
        if (this.ozStub == null) {
            System.err.println(OZ_NOTREADY_MSG);
            return;
        }
        this.ozStub.openFile();
    }

    public void saveFile(String code) {
        if (this.ozStub == null) {
            System.err.println(OZ_NOTREADY_MSG);
            return;
        }
        this.ozStub.saveFile(code);
    }
}

