/*
 * Decompiled with CFR 0.152.
 */
package com.ScienceActive.ctmcp.applet;

import com.ScienceActive.SATuner.net.SATunerAnswer;
import com.ScienceActive.SATuner.net.SATunerConnection;
import com.ScienceActive.SATuner.net.SATunerRequest;
import com.ScienceActive.ctmcp.applet.Config;
import com.ScienceActive.ctmcp.applet.ValidationDialog;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.JOptionPane;

public class Validation {
    private final String TUNER_SERVLET_URL = "http://www.scienceactive.com/v3/servlet/SATunerServlet";
    private Config config = null;

    public Validation(Config config) {
        this.config = config;
    }

    public boolean isValid() {
        if (this.config == null) {
            JOptionPane.showMessageDialog(null, "Votre fichier de configuration n'est pas valide.", "Erreur", 0);
            return false;
        }
        int ret = this.checkForValidity();
        if (ret == 0) {
            return true;
        }
        if (ret == 1) {
            JOptionPane.showMessageDialog(null, "Votre fichier de configuration n'est pas valide.", "Erreur", 0);
            return false;
        }
        if (ret == 2) {
            return this.askForValidation();
        }
        if (ret == 3) {
            return this.askForValidation();
        }
        return false;
    }

    private int checkForValidity() {
        if (this.config == null) {
            return 1;
        }
        String user = this.config.get(Config.PROP_USER);
        String email = this.config.get(Config.PROP_EMAIL);
        String codevalid = this.config.get(Config.PROP_CODEVALID);
        String nbCopiesStr = this.config.get(Config.PROP_NBCOPIES);
        if (user.equals("") || email.equals("") || codevalid.equals("") || nbCopiesStr.equals("")) {
            return 2;
        }
        String codeconfirm = this.config.get(Config.PROP_CODECONFIRM);
        String codedate = this.config.get(Config.PROP_CODEDATE);
        if (codedate.equals("") || codeconfirm.equals("")) {
            return 3;
        }
        long nbCopies = 1L;
        try {
            nbCopies = Long.parseLong(nbCopiesStr);
            if (nbCopies <= 0L) {
                return 3;
            }
        }
        catch (NumberFormatException nfe) {
            return 3;
        }
        String network = this.config.get(Config.PROP_NETWORK);
        if (nbCopies == 1L ? !network.equals("") : network.equals("")) {
            return 3;
        }
        return this.hasConfigMoved(nbCopies);
    }

    private int hasConfigMoved(long nbCopies) {
        String codedate = this.config.get(Config.PROP_CODEDATE);
        String network = this.config.get(Config.PROP_NETWORK);
        String codeValid = this.config.get(Config.PROP_CODEVALID);
        String hostname = null;
        String address = null;
        try {
            InetAddress local = InetAddress.getLocalHost();
            hostname = local.getHostName();
            address = local.getHostAddress();
        }
        catch (UnknownHostException e) {
            return 3;
        }
        if (nbCopies == 1L) {
            if (!(hostname = this.hostToLong(hostname)).equals(codedate)) {
                return 3;
            }
            return 0;
        }
        hostname = this.hostToLong(String.valueOf(network) + codeValid);
        if (!hostname.equals(codedate)) {
            return 3;
        }
        if (address.startsWith(network)) {
            return 0;
        }
        return 3;
    }

    private String hostToLong(String hostname) {
        return Long.toString(Math.abs(hostname.hashCode()));
    }

    private boolean askForValidation() {
        this.config.set(Config.PROP_CODEDATE, "");
        this.config.set(Config.PROP_CODECONFIRM, "");
        this.config.set(Config.PROP_NETWORK, "");
        this.config.set(Config.PROP_NBCOPIES, "1");
        ValidationDialog vd = new ValidationDialog(this.config);
        vd.setStep(1);
        vd.setVisible(true);
        if (!vd.isValidated()) {
            return false;
        }
        this.config = vd.getConfig();
        int ret = this.doValidation();
        switch (ret) {
            case 0: {
                this.config.save();
                break;
            }
            case 4: {
                JOptionPane.showMessageDialog(null, "La validation de votre installation a \u00e9t\u00e9 refus\u00e9e. V\u00e9rifiez que\nvous n'avez pas install\u00e9 toutes les copies disponibles.", "Erreur", 0);
                return false;
            }
            case 5: {
                JOptionPane.showMessageDialog(null, "Le serveur de validation n'a pas pu \u00eatre contact\u00e9. V\u00e9rifiez votre\nconnexion Internet et renouvelez l'op\u00e9ration.", "Erreur", 0);
                return false;
            }
            case 6: {
                JOptionPane.showMessageDialog(null, "Les informations de validation n'ont pas pu \u00eatre consult\u00e9es.\nV\u00e9rifiez votre installation.", "Erreur", 0);
                return false;
            }
            default: {
                return false;
            }
        }
        vd.setStep(2);
        vd.setVisible(true);
        if (!vd.isValidated()) {
            return false;
        }
        Config tempConfig = vd.getConfig();
        if (tempConfig.get(Config.PROP_CODECONFIRM).equals("")) {
            JOptionPane.showMessageDialog(null, "Le code de confirmation n'est pas valide. Consultez votre\ncourrier \u00e9lectronique afin de le v\u00e9rifier.", "Erreur", 0);
            return false;
        }
        this.config = tempConfig;
        int ret2 = this.doConfirmValidation();
        switch (ret2) {
            case 0: {
                this.config.save();
                return true;
            }
            case 4: {
                JOptionPane.showMessageDialog(null, "Le code de confirmation n'est pas valide. Consultez votre\ncourrier \u00e9lectronique afin de le v\u00e9rifier.", "Erreur", 0);
                return false;
            }
            case 5: {
                JOptionPane.showMessageDialog(null, "Le serveur de validation n'a pas pu \u00eatre contact\u00e9. V\u00e9rifiez votre\nconnexion Internet et renouvelez l'op\u00e9ration.", "Erreur", 0);
                return false;
            }
        }
        return false;
    }

    private int doValidation() {
        Config tempConfig = this.config;
        try {
            InetAddress local = InetAddress.getLocalHost();
            String hostname = local.getHostName();
            tempConfig.set(Config.PROP_CODEDATE, this.hostToLong(hostname));
            int ret = this.registerValidation(tempConfig, local);
            if (ret == 0) {
                this.config = tempConfig;
            }
            return ret;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return 6;
        }
    }

    private int registerValidation(Config tempConfig, InetAddress local) {
        SATunerRequest request = new SATunerRequest(7);
        request.putArg(Config.PROP_USER, tempConfig.get(Config.PROP_USER));
        request.putArg(Config.PROP_EMAIL, tempConfig.get(Config.PROP_EMAIL));
        request.putArg(Config.PROP_CODEVALID, tempConfig.get(Config.PROP_CODEVALID));
        request.putArg(Config.PROP_CODEDATE, tempConfig.get(Config.PROP_CODEDATE));
        request.putArg("ipaddress", local.getHostAddress());
        request.putArg("hostname", local.getHostName());
        SATunerConnection conn = new SATunerConnection("http://www.scienceactive.com/v3/servlet/SATunerServlet");
        SATunerAnswer answer = conn.send(request);
        switch (answer.getStatus()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 4;
            }
            case 4: {
                return 5;
            }
        }
        return 5;
    }

    private int doConfirmValidation() {
        SATunerRequest request = new SATunerRequest(8);
        request.putArg(Config.PROP_CODECONFIRM, this.config.get(Config.PROP_CODECONFIRM));
        SATunerConnection conn = new SATunerConnection("http://www.scienceactive.com/v3/servlet/SATunerServlet");
        SATunerAnswer answer = conn.send(request);
        switch (answer.getStatus()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 4;
            }
            case 4: {
                return 5;
            }
        }
        return 5;
    }
}

