/*
 * Decompiled with CFR 0.152.
 */
package com.ScienceActive.ctmcp.applet.opi;

import com.ScienceActive.ctmcp.applet.opi.OzMessage;
import com.ScienceActive.ctmcp.applet.opi.ReprOzCons;
import com.ScienceActive.ctmcp.applet.opi.ReprOzNuple;
import com.ScienceActive.ctmcp.applet.opi.ReprOzPar;
import com.ScienceActive.ctmcp.applet.opi.ReprOzRecord;
import com.ScienceActive.ctmcp.applet.opi.ReprOzTransient;
import com.ScienceActive.ctmcp.applet.opi.ReprOzTuple;
import com.ScienceActive.ctmcp.applet.opi.ReprOzValue;
import java.applet.Applet;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JApplet;
import javax.swing.JEditorPane;
import javax.swing.text.html.HTMLDocument;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;

public class OzBrowserListener
extends JEditorPane {
    private static final long serialVersionUID = 6732880771938285099L;
    private Map<String, ReprOzValue> table = new HashMap<String, ReprOzValue>();
    private JSObject fen = null;
    private JApplet applet = null;

    public OzBrowserListener(JApplet applet) {
        this.applet = applet;
        this.setEditable(false);
        this.setContentType("text/html");
        this.setText("<html><body><div id=\"root\"></div></body></html>");
    }

    private void invokeBrowser(String str) {
        try {
            if (this.fen == null) {
                this.fen = JSObject.getWindow((Applet)this.applet);
            }
            this.fen.eval(str);
        }
        catch (JSException e) {
            e.printStackTrace();
        }
    }

    private void invokeBrowser(String fun, String[] args) {
        try {
            if (this.fen == null) {
                this.fen = JSObject.getWindow((Applet)this.applet);
            }
            this.fen.call(fun, args);
        }
        catch (JSException e) {
            e.printStackTrace();
        }
    }

    private void invokeBrowser(String fun, String arg) {
        try {
            if (this.fen == null) {
                this.fen = JSObject.getWindow((Applet)this.applet);
            }
            this.fen.call(fun, arg);
        }
        catch (JSException e) {
            e.printStackTrace();
        }
    }

    public void doStdout(String text) {
        try {
            this.invokeBrowser("browser_stdout", new String[]{text});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doStderr(String text) {
        try {
            this.invokeBrowser("browser_stderr", new String[]{text});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doCmd(OzMessage msg) {
        String t = msg.getChild(0).stringValue();
        if (t.equals("val")) {
            this.tellVal(msg.getChild(1).stringValue(), msg.getChild(2).stringValue());
        } else if (t.equals("tuple")) {
            this.tellTuple(msg.getChild(1).stringValue(), msg.getChild(2).stringValue(), msg.getChild(3));
        } else if (t.equals("nuple")) {
            this.tellNuple(msg.getChild(1).stringValue(), msg.getChild(2));
        } else if (t.equals("record")) {
            this.tellRecord(msg.getChild(1).stringValue(), msg.getChild(2).stringValue(), msg.getChild(3));
        } else if (t.equals("transient")) {
            this.tellTrans(msg.getChild(1).stringValue(), msg.getChild(2).stringValue());
        } else if (t.equals("par")) {
            this.tellPar(msg.getChild(1).stringValue(), msg.getChild(2).stringValue());
        } else if (t.equals("cons")) {
            this.tellCons(msg.getChild(1).stringValue(), msg.getChild(2).stringValue(), msg.getChild(3).stringValue());
        } else if (t.equals("update")) {
            this.updateTrans(msg.getChild(1).stringValue(), msg.getChild(2).stringValue());
        } else if (t.equals("browse")) {
            this.browse(msg.getChild(1).stringValue());
        } else if (t.equals("newbrowse")) {
            this.newbrowse(msg.getChild(1).stringValue());
        } else if (t.equals("browseupd")) {
            this.browseupdate(msg.getChild(1).stringValue(), msg.getChild(2).stringValue());
        }
    }

    private void newbrowse(String b) {
        this.invokeBrowser("browser_addElement", b);
    }

    private void browseupdate(String id, String b) {
        this.invokeBrowser("browser_replaceElement", new String[]{id, b});
    }

    private void tellVal(String key, String val) {
        this.table.put(key, new ReprOzValue(key, val));
    }

    private void tellTuple(String key, String label, OzMessage fields) {
        ReprOzValue[] fs = new ReprOzValue[fields.getWidth()];
        int i = 0;
        while (i < fields.getWidth()) {
            fs[i] = this.table.get(fields.getChild(i).stringValue());
            ++i;
        }
        String labkey = String.valueOf(key) + "label";
        this.table.put(key, new ReprOzTuple(key, new ReprOzValue(labkey, label), fs));
    }

    private void tellNuple(String key, OzMessage fields) {
        ReprOzValue[] fs = new ReprOzValue[fields.getWidth()];
        int i = 0;
        while (i < fields.getWidth()) {
            fs[i] = this.table.get(fields.getChild(i).stringValue());
            ++i;
        }
        this.table.put(key, new ReprOzNuple(key, fs));
    }

    private void tellCons(String key, String lKey, String rKey) {
        this.table.put(key, new ReprOzCons(key, this.table.get(lKey), this.table.get(rKey)));
    }

    private void tellRecord(String key, String keyLabel, OzMessage arityAndFields) {
        ReprOzValue[] fs = new ReprOzValue[arityAndFields.getWidth()];
        int i = 0;
        while (i < arityAndFields.getWidth()) {
            fs[i] = this.table.get(arityAndFields.getChild(i).stringValue());
            ++i;
        }
        this.table.put(key, new ReprOzRecord(key, this.table.get(keyLabel), fs));
    }

    private void tellTrans(String key, String contentKey) {
        this.table.put(key, new ReprOzTransient(key, this.table.get(contentKey)));
    }

    private void tellPar(String key, String contentKey) {
        this.table.put(key, new ReprOzPar(key, this.table.get(contentKey)));
    }

    private void updateTrans(String key, String contentKey) {
        if (!this.table.containsKey(key)) {
            return;
        }
        ((ReprOzTransient)this.table.get(key)).setContent(this.table.get(contentKey));
        this.invokeBrowser("browser_replaceElement('" + key + "', '" + this.table.get(key).toHTML() + "')");
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        try {
            doc.setOuterHTML(doc.getElement(key), this.table.get(key).toHTML());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void browse(String key) {
        this.invokeBrowser("browser_addElement('" + this.table.get(key).toHTML() + "')");
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        try {
            doc.insertBeforeStart(doc.getElement("root"), "<div>" + this.table.get(key).toHTML() + "</div>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clear() {
        this.table.clear();
        this.invokeBrowser("browser_clear()");
        this.setText("<div id=\"root\"></div>");
    }

    public void invokeFunction(String fun) {
        this.invokeBrowser(fun);
    }

    public void invokeFunction(String fun, String arg) {
        this.invokeBrowser(fun, arg);
    }
}

