/*
 * Decompiled with CFR 0.152.
 */
package com.ScienceActive.ctmcp.applet.opi;

import com.ScienceActive.ctmcp.applet.opi.util.ByteString;
import com.ScienceActive.ctmcp.applet.opi.util.ByteStringBuffer;

public class OzMessage {
    public static final int INT = 0;
    public static final int STRING = 1;
    public static final int COMPOSITE = 2;
    private int kind;
    private int _i;
    private ByteString _s;
    private OzMessage[] _m;

    public OzMessage(int i) {
        this.kind = 0;
        this._i = i;
    }

    public OzMessage(String s) {
        this.kind = 1;
        this._s = new ByteString(s);
    }

    public OzMessage(ByteString s) {
        this.kind = 1;
        this._s = s;
    }

    public OzMessage(OzMessage[] m) {
        this.kind = 2;
        this._m = m;
    }

    public int getKind() {
        return this.kind;
    }

    public int intValue() {
        return this._i;
    }

    public ByteString byteStringValue() {
        return this._s;
    }

    public String stringValue() {
        return new String(this._s.toByteArray());
    }

    public int getWidth() {
        return this._m.length;
    }

    public OzMessage getChild(int i) {
        return this._m[i];
    }

    private static void addInt(ByteStringBuffer sb, int i) {
        sb.add(OzMessage.intToBytes(i));
    }

    public static byte[] intToBytes(int i) {
        return new byte[]{(byte)(i % 256), (byte)(i / 256 % 256), (byte)(i / 65536 % 256), (byte)(i / 0x1000000 % 256)};
    }

    public static int bytesToInt(byte[] bs) {
        int[] bbs = new int[4];
        int i = 0;
        while (i < 4) {
            bbs[i] = bs[i] < 0 ? bs[i] + 256 : bs[i];
            ++i;
        }
        return bbs[0] + bbs[1] * 256 + bbs[2] * 65536 + bbs[3] * 0x1000000;
    }

    private static void addString(ByteStringBuffer sb, ByteString s) {
        OzMessage.addInt(sb, s.length());
        sb.add(s);
    }

    public ByteString toByteString() {
        ByteStringBuffer sb = new ByteStringBuffer();
        OzMessage.addInt(sb, this.kind);
        switch (this.kind) {
            case 0: {
                OzMessage.addInt(sb, this._i);
                break;
            }
            case 1: {
                OzMessage.addString(sb, this._s);
                break;
            }
            case 2: {
                OzMessage.addInt(sb, this._m.length);
                int i = 0;
                while (i < this._m.length) {
                    sb.add(this._m[i].toByteString());
                    ++i;
                }
                break;
            }
        }
        return sb.toByteString();
    }

    public static class Maker {
        private ByteStringBuffer c = new ByteStringBuffer();
        private int length = -1;
        private int cur = 0;

        public void push(byte[] bs) {
            this.c.add(bs);
        }

        public OzMessage get() {
            if (this.length == -1 && this.c.size() < 4) {
                return null;
            }
            if (this.length == -1) {
                byte[] t = this.c.toByteString().toByteArray();
                this.cur = 0;
                this.length = this.getInt(t);
                byte[] nt = new byte[t.length - 4];
                int i = 0;
                while (i < nt.length) {
                    nt[i] = t[i + 4];
                    ++i;
                }
                this.c = new ByteStringBuffer();
                this.c.add(nt);
            }
            if (this.c.size() < this.length) {
                return null;
            }
            byte[] bs = this.c.toByteString().toByteArray();
            this.cur = 0;
            OzMessage r = this.get(bs);
            this.length = -1;
            byte[] nt = new byte[bs.length - this.cur];
            int i = 0;
            while (i < nt.length) {
                nt[i] = bs[i + this.cur];
                ++i;
            }
            this.c = new ByteStringBuffer();
            this.c.add(nt);
            return r;
        }

        private OzMessage get(byte[] bs) {
            switch (this.getInt(bs)) {
                case 0: {
                    return new OzMessage(this.getInt(bs));
                }
                case 1: {
                    int l = this.getInt(bs);
                    return new OzMessage(new ByteString(this.getString(bs, l)));
                }
                case 2: {
                    int w = this.getInt(bs);
                    OzMessage[] t = new OzMessage[w];
                    int i = 0;
                    while (i < w) {
                        t[i] = this.get(bs);
                        ++i;
                    }
                    return new OzMessage(t);
                }
            }
            return null;
        }

        private int getInt(byte[] bs) {
            this.cur += 4;
            return OzMessage.bytesToInt(new byte[]{bs[this.cur - 4], bs[this.cur - 3], bs[this.cur - 2], bs[this.cur - 1]});
        }

        private byte[] getString(byte[] bs, int l) {
            byte[] r = new byte[l];
            int i = 0;
            while (i < l) {
                r[i] = bs[this.cur++];
                ++i;
            }
            return r;
        }
    }
}

