/*
 * Decompiled with CFR 0.152.
 */
package com.ScienceActive.ctmcp.applet.opi;

import com.ScienceActive.ctmcp.applet.opi.OzBrowserListener;
import com.ScienceActive.ctmcp.applet.opi.OzMessage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class OzStub {
    public static final String OZENGINE = "ozengine";
    public static final String OZINTERFACE = "interf.ozf";
    private ConcurrentLinkedQueue<OzMessage> msgSendQueue = null;
    private Object listener = null;
    private CommThread commThread = null;
    private Thread thread = null;
    private Process ozEngine = null;
    private BufferedOutputStream toOz = null;
    private BufferedInputStream fromOz = null;
    private BufferedInputStream fromOzErr = null;
    private boolean remote = false;
    private BufferedInputStream fromOzOut;
    private int basePingId = 0;

    public boolean send(OzMessage msg) {
        if (this.msgSendQueue != null) {
            if (!this.remote) {
                if (this.basePingId > 16384) {
                    this.basePingId = 0;
                }
                OzMessage pingMsg = new OzMessage(new OzMessage[]{new OzMessage("ping"), new OzMessage(String.valueOf(this.basePingId))});
                this.msgSendQueue.add(pingMsg);
            }
            this.msgSendQueue.add(msg);
        }
        return true;
    }

    public boolean addListener(Object l) {
        if (this.listener == null) {
            this.listener = l;
            return true;
        }
        return false;
    }

    private void invokeJSFun(String fun, String arg) {
        ((OzBrowserListener)this.listener).invokeFunction(fun, arg);
    }

    private void sendToListeners(OzMessage s) {
        String t = s.getChild(0).stringValue();
        if (t.equals("stdout")) {
            String text = s.getChild(1).stringValue();
            ((OzBrowserListener)this.listener).doStdout(text);
        } else if (t.equals("stderr")) {
            String text = s.getChild(1).stringValue();
            ((OzBrowserListener)this.listener).doStderr(text);
        } else if (t.equals("browser")) {
            OzMessage cmd = s.getChild(1);
            ((OzBrowserListener)this.listener).doCmd(cmd);
        }
    }

    public OzStub(boolean remote) throws Exception {
        System.out.println("OzStub - creating");
        this.remote = remote;
        this.msgSendQueue = new ConcurrentLinkedQueue();
        this.commThread = new CommThread();
        this.thread = new Thread(this.commThread);
        this.thread.start();
    }

    public void startup(String ozName, String ozPath, String laboPath) {
        System.out.println("OzStub - starting");
        if (this.commThread != null) {
            this.commThread.startIt(ozName, ozPath, laboPath);
        }
    }

    public void shutdown() {
        System.out.println("OzStub - stopping");
        this.send(new OzMessage(new OzMessage[]{new OzMessage("oz"), new OzMessage("quit")}));
        if (this.commThread != null) {
            this.commThread.stopIt();
        }
    }

    public void clear() {
        System.out.println("OzStub - clearing");
        ((OzBrowserListener)this.listener).clear();
    }

    public void restart() {
        System.out.println("OzStub - restarting");
        if (this.commThread != null) {
            this.commThread.restartIt();
        }
    }

    public void openFile() {
        if (this.commThread != null) {
            this.commThread.openFile();
        }
    }

    public void saveFile(String code) {
        if (this.commThread != null) {
            this.commThread.saveFile(code);
        }
    }

    public void killEngine() {
        System.out.println("OzStub - killing");
        if (this.commThread != null) {
            this.commThread.killEngine();
        }
    }

    class CommThread
    implements Runnable {
        private boolean mustStop = false;
        private boolean mustStart = false;
        private boolean mustRestart = false;
        private boolean mustWaitForPong = false;
        private boolean askOpenFile = false;
        private boolean askSaveFile = false;
        private String codeStr = null;
        private String laboPath = null;
        private String ozPath = null;
        private String ozName = null;
        private String pongId = null;
        private int pingTimeout = 0;
        private boolean pongReceived = false;
        private int rest = 0;
        private OzMessage.Maker maker = new OzMessage.Maker();

        CommThread() {
        }

        public void stopIt() {
            System.out.println("CommThread - asking for stop");
            this.mustStop = true;
        }

        public void startIt(String ozName, String ozPath, String laboPath) {
            System.out.println("CommThread - asking for start");
            if (OzStub.this.remote) {
                this.ozPath = ozPath;
            } else {
                this.ozName = ozName;
                this.ozPath = ozPath;
                this.laboPath = laboPath;
                if (!this.ozPath.endsWith(File.separator)) {
                    this.ozPath = String.valueOf(this.ozPath) + File.separator;
                }
                if (!this.laboPath.endsWith(File.separator)) {
                    this.laboPath = String.valueOf(this.laboPath) + File.separator;
                }
            }
            this.mustStart = true;
        }

        public void restartIt() {
            System.out.println("CommThread - asking for restart");
            this.mustRestart = true;
        }

        public void openFile() {
            this.askOpenFile = true;
        }

        public void saveFile(String code) {
            this.askSaveFile = true;
            this.codeStr = code;
        }

        public void killEngine() {
            if (OzStub.this.ozEngine != null) {
                OzStub.this.ozEngine.destroy();
                System.out.println("Killing Oz engine");
                OzStub.this.ozEngine = null;
            }
        }

        private void launchOz() {
            System.out.println("CommThread - launching Oz engine");
            if (OzStub.this.remote) {
                try {
                    System.out.println("CommThread - connection to server");
                    Socket s = new Socket(this.ozPath, 1234);
                    OzStub.this.toOz = new BufferedOutputStream(s.getOutputStream());
                    OzStub.this.fromOz = new BufferedInputStream(s.getInputStream());
                    OzStub.this.fromOzOut = null;
                    OzStub.this.fromOzErr = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    if (OzStub.this.ozEngine != null) {
                        OzStub.this.ozEngine.destroy();
                        OzStub.this.ozEngine = null;
                    }
                    System.out.println("CommThread - starting Oz engine");
                    System.out.println("   --> " + this.ozPath + this.ozName + " " + this.laboPath + OzStub.OZINTERFACE);
                    ServerSocket ss = new ServerSocket(0);
                    ProcessBuilder pb = new ProcessBuilder(String.valueOf(this.ozPath) + this.ozName, String.valueOf(this.laboPath) + OzStub.OZINTERFACE, Integer.toString(ss.getLocalPort()));
                    OzStub.this.ozEngine = pb.start();
                    if (OzStub.this.ozEngine == null) {
                        throw new Exception("Impossible de d\u00e9marrer Oz");
                    }
                    Socket s = ss.accept();
                    OzStub.this.toOz = new BufferedOutputStream(s.getOutputStream());
                    OzStub.this.fromOz = new BufferedInputStream(s.getInputStream());
                    OzStub.this.fromOzOut = new BufferedInputStream(OzStub.this.ozEngine.getInputStream());
                    OzStub.this.fromOzErr = new BufferedInputStream(OzStub.this.ozEngine.getErrorStream());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void waitForPong(String id) {
            this.pongId = id;
            this.pingTimeout = OzStub.this.remote ? 2000 : 200;
            this.pongReceived = false;
            this.mustWaitForPong = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block13: while (true) {
                try {
                    while (true) {
                        Object msg2;
                        byte[] tab;
                        if (this.askOpenFile) {
                            this.askOpenFile = false;
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    public void run() {
                                        JFileChooser chooser = new JFileChooser();
                                        int returnVal = chooser.showOpenDialog(null);
                                        FileInputStream fis = null;
                                        if (returnVal == 0) {
                                            try {
                                                try {
                                                    File file = chooser.getSelectedFile();
                                                    fis = new FileInputStream(file);
                                                    byte[] buf = new byte[10];
                                                    String codeStr = "";
                                                    int bread = -1;
                                                    do {
                                                        if ((bread = fis.read(buf)) == -1) continue;
                                                        codeStr = String.valueOf(codeStr) + new String(buf, 0, bread, "ISO-8859-1");
                                                    } while (bread != -1);
                                                    OzStub.this.invokeJSFun("browser_openFile", codeStr);
                                                }
                                                catch (IOException ioe) {
                                                    ioe.printStackTrace();
                                                    try {
                                                        fis.close();
                                                    }
                                                    catch (IOException iOException) {}
                                                }
                                            }
                                            finally {
                                                try {
                                                    fis.close();
                                                }
                                                catch (IOException iOException) {}
                                            }
                                        }
                                    }
                                });
                            }
                            catch (InterruptedException ie) {
                                ie.printStackTrace();
                            }
                            catch (InvocationTargetException ite) {
                                ite.printStackTrace();
                            }
                        }
                        if (this.askSaveFile) {
                            this.askSaveFile = false;
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    public void run() {
                                        JFileChooser chooser = new JFileChooser();
                                        int returnVal = chooser.showSaveDialog(null);
                                        FileOutputStream fos = null;
                                        if (returnVal == 0) {
                                            try {
                                                try {
                                                    File file = chooser.getSelectedFile();
                                                    fos = new FileOutputStream(file);
                                                    fos.write(CommThread.this.codeStr.getBytes());
                                                }
                                                catch (IOException ioe) {
                                                    ioe.printStackTrace();
                                                    try {
                                                        fos.close();
                                                    }
                                                    catch (IOException iOException) {}
                                                }
                                            }
                                            finally {
                                                try {
                                                    fos.close();
                                                }
                                                catch (IOException iOException) {}
                                            }
                                        }
                                    }
                                });
                            }
                            catch (InterruptedException ie) {
                                ie.printStackTrace();
                            }
                            catch (InvocationTargetException ite) {
                                ite.printStackTrace();
                            }
                        }
                        if (this.mustStop) {
                            System.out.println("CommThread - stoppping Oz engine");
                            OzStub.this.msgSendQueue = null;
                            OzStub.this.toOz = null;
                            OzStub.this.fromOz = null;
                            OzStub.this.fromOzErr = null;
                            OzStub.this.fromOzOut = null;
                            if (OzStub.this.ozEngine == null) break block13;
                            OzStub.this.ozEngine.destroy();
                            OzStub.this.ozEngine = null;
                            break block13;
                        }
                        if (this.mustStart) {
                            this.launchOz();
                            this.mustStart = false;
                            this.mustWaitForPong = false;
                            ((OzBrowserListener)OzStub.this.listener).invokeFunction("helloOz()");
                        }
                        if (this.mustRestart) {
                            OzStub.this.msgSendQueue.clear();
                            OzStub.this.toOz = null;
                            OzStub.this.fromOz = null;
                            OzStub.this.fromOzErr = null;
                            OzStub.this.fromOzOut = null;
                            System.out.println("CommThread - stoppping Oz engine");
                            if (OzStub.this.ozEngine != null) {
                                OzStub.this.ozEngine.destroy();
                            }
                            this.launchOz();
                            this.mustRestart = false;
                            this.mustWaitForPong = false;
                            ((OzBrowserListener)OzStub.this.listener).invokeFunction("helloOz()");
                        }
                        if (this.mustWaitForPong) {
                            --this.pingTimeout;
                            if (this.pingTimeout < 0) {
                                this.mustWaitForPong = false;
                                if (!this.pongReceived) {
                                    System.err.println("Pas de r\u00e9ponse du moteur Oz");
                                    JOptionPane.showMessageDialog(null, "Le syst\u00e8me Mozart ne r\u00e9pond pas. Cliquez sur le bouton\n'Relancer Oz' pour le red\u00e9marrer.", "Erreur", 0);
                                }
                            }
                        }
                        if (OzStub.this.fromOz != null && OzStub.this.fromOz.available() > 0) {
                            if (OzStub.this.remote) {
                                tab = new byte[OzStub.this.fromOz.available()];
                                OzStub.this.fromOz.read(tab);
                                this.maker.push(tab);
                                OzMessage r = this.maker.get();
                                while (r != null) {
                                    OzStub.this.sendToListeners(r);
                                    r = this.maker.get();
                                }
                            } else {
                                byte[] tabEncoded = new byte[OzStub.this.fromOz.available()];
                                byte[] tab2 = new byte[(OzStub.this.fromOz.available() + (this.rest != 0 ? 1 : 0)) / 2];
                                OzStub.this.fromOz.read(tabEncoded);
                                if (this.rest != 0) {
                                    byte[] tabEncoded2 = new byte[OzStub.this.fromOz.available() + 1];
                                    int i = 0;
                                    while (i < tabEncoded.length) {
                                        tabEncoded2[i + 1] = tabEncoded[i];
                                        ++i;
                                    }
                                    tabEncoded2[0] = (byte)(this.rest - 97);
                                    this.rest = 0;
                                    tabEncoded = tabEncoded2;
                                }
                                int i = 0;
                                while (i < tab2.length) {
                                    tab2[i] = (byte)((tabEncoded[2 * i] - 97) * 16 + (tabEncoded[2 * i + 1] - 65));
                                    ++i;
                                }
                                if (tabEncoded.length % 2 == 1) {
                                    this.rest = tabEncoded[tabEncoded.length - 1];
                                }
                                this.maker.push(tab2);
                                OzMessage r = this.maker.get();
                                while (r != null) {
                                    String id;
                                    String t = r.getChild(0).stringValue();
                                    if (t.equals("pong") && (id = r.getChild(1).stringValue()).equals(this.pongId)) {
                                        this.pongReceived = true;
                                        this.mustWaitForPong = false;
                                    }
                                    OzStub.this.sendToListeners(r);
                                    r = this.maker.get();
                                }
                            }
                        }
                        if (OzStub.this.fromOzOut != null && OzStub.this.fromOzOut.available() > 0) {
                            tab = new byte[OzStub.this.fromOzOut.available()];
                            OzStub.this.fromOzOut.read(tab);
                            ((OzBrowserListener)OzStub.this.listener).doStdout(new String(tab));
                        }
                        if (OzStub.this.fromOzErr != null && OzStub.this.fromOzErr.available() > 0) {
                            tab = new byte[OzStub.this.fromOzErr.available()];
                            OzStub.this.fromOzErr.read(tab);
                            ((OzBrowserListener)OzStub.this.listener).doStderr(new String(tab));
                        }
                        if (!this.mustWaitForPong && OzStub.this.msgSendQueue != null && !OzStub.this.msgSendQueue.isEmpty()) {
                            msg2 = (OzMessage)OzStub.this.msgSendQueue.poll();
                            if (!OzStub.this.remote && ((OzMessage)msg2).getChild(0).stringValue().equals("ping")) {
                                this.waitForPong(((OzMessage)msg2).getChild(1).stringValue());
                            }
                            byte[] s = ((OzMessage)msg2).toByteString().toByteArray();
                            if (OzStub.this.toOz != null) {
                                OzStub.this.toOz.write(OzMessage.intToBytes(s.length));
                                OzStub.this.toOz.write(s);
                                OzStub.this.toOz.flush();
                            }
                        }
                        try {
                            msg2 = this;
                            synchronized (msg2) {
                                this.wait(10L);
                                continue;
                            }
                        }
                        catch (Exception msg2) {
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

