/*
 * Decompiled with CFR 0.152.
 */
package com.ScienceActive.ctmcp.applet.opi;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

public class ReprOzValue {
    protected String display;
    protected boolean isDisplayed;
    String k;
    protected JTextComponent text;
    protected Position startPos;

    public ReprOzValue(String key, String display) {
        this.k = key;
        this.display = display;
    }

    public String toHTML() {
        return "<span id=\"" + this.k + "\">" + this.display + "</span>";
    }

    protected void doDraw(int offset) throws BadLocationException {
        System.err.println(String.valueOf(this.display) + " " + offset);
        this.text.getDocument().insertString(offset, this.display, null);
    }

    public void draw(JTextComponent t, int offset) {
        this.text = t;
        try {
            this.doDraw(offset);
            this.startPos = this.text.getDocument().createPosition(offset);
            this.isDisplayed = true;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void clean() {
        if (this.isDisplayed) {
            this.remove();
        }
        this.isDisplayed = false;
    }

    protected void doRemove() throws BadLocationException {
        this.text.getDocument().remove(this.startPos.getOffset(), this.display.length());
    }

    public int endOffset() {
        return this.startPos.getOffset() + this.display.length();
    }

    public void remove() {
        try {
            this.doRemove();
            this.isDisplayed = false;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void setDisplay(String d) {
        boolean state = this.isDisplayed;
        if (state) {
            this.remove();
        }
        this.display = d;
        if (state) {
            this.draw(this.text, this.startPos.getOffset());
        }
    }

    public String toString() {
        return this.display;
    }
}

