/**
 * Geometrie.js : fonctions portables permettant dobtenir des informations 
 *                de gomtrie dune fentre et dun document.
 *
 * Ce module dfinit des fonctions permettant dobtenir des informations de
 * gomtrie dune fentre et dun document.
 * 
 * lirePosXFenetre/lirePosYFenetre() : retourne la position de la fentre 
 *        sur lcran.
 * lireLargeurAffichage/lireHauteurAffichage() : retourne la taille de la 
 *        zone daffichage du navigateur.
 * lireLargeurDocument/lireHauteurDocument() : retourne la taille du document.
 * lireDefilementHorizontal() : retourne la position de la barre de dfilement
 *        horizontale.
 * lireDefilementVertical() : retourne la position de la barre de dfilement
 *        verticale.
 *
 * Notez quil nexiste aucune manire portable dobtenir la taille globale 
 * de la fentre du navigateur. Par consquent les fonctions
 * lireLargeurFenetre() et lireHauteurFenetre() nexistent pas.
 * 
 * IMPORTANT : ce module doit tre inclus dans le corps (<body>) du document
 *             et non dans son en-tte (<head>).
 */
var Geometrie = {};

if (window.screenLeft) { // IE et les autres.
    Geometrie.lirePosXFenetre = function() { return window.screenLeft; };
    Geometrie.lirePosYFenetre = function() { return window.screenTop; };
}
else if (window.screenX) { // Firefox et les autres.
    Geometrie.lirePosXFenetre = function() { return window.screenX; };
    Geometrie.lirePosYFenetre = function() { return window.screenY; };
}

if (window.innerWidth) { // Tous les navigateurs except IE.
    Geometrie.lireLargeurAffichage = function() { return window.innerWidth; };
    Geometrie.lireHauteurAffichage = function() { return window.innerHeight; };
    Geometrie.lireDefilementHorizontal = function() {
        return window.pageXOffset; };
    Geometrie.lireDefilementVertical = function() { 
        return window.pageYOffset; };
}
else if (document.documentElement && document.documentElement.clientWidth) {
    // Ces fonctions sont destines  IE6 lorsquil contient une 
    // dclaration DOCTYPE.
    Geometrie.lireLargeurAffichage =
        function() { return document.documentElement.clientWidth; };
    Geometrie.lireHauteurAffichage = 
        function() { return document.documentElement.clientHeight; };
    Geometrie.lireDefilementHorizontal = 
        function() { return document.documentElement.scrollLeft; };
    Geometrie.lireDefilementVertical = 
        function() { return document.documentElement.scrollTop; };
}
else if (document.body.clientWidth) {
    // Celles-ci sont pour IE4, IE5 et IE6 sans dclaration DOCTYPE.
    Geometrie.lireLargeurAffichage =
        function() { return document.body.clientWidth; };
    Geometrie.lireHauteurAffichage =
        function() { return document.body.clientHeight; };
    Geometrie.lireDefilementHorizontal =
        function() { return document.body.scrollLeft; };
    Geometrie.lireDefilementVertical = 
        function() { return document.body.scrollTop; };
}

// Ces fonctions retournent la taille du document. Elles ne concernent pas
// les fentres, mais il est utile de les avoir ici.
if (document.documentElement && document.documentElement.scrollWidth) {
    Geometrie.lireLargeurDocument =
        function() { return document.documentElement.scrollWidth; };
    Geometrie.lireHauteurDocument =
        function() { return document.documentElement.scrollHeight; };
}
else if (document.body.scrollWidth) {
    Geometrie.lireLargeurDocument =
        function() { return document.body.scrollWidth; };
    Geometrie.lireHauteurDocument =
        function() { return document.body.scrollHeight; };
}