/**
 * Glisser.js : faire glisser les lments HTML positionns de manire absolue.
 *
 * Ce module dfinit la fonction drag() conue pour tre appele depuis
 * un gestionnaire dvnements onmousedown. Les vnements mousemove
 * survenant ensuite dplacent llment indiqu. Un vnement mouseup 
 * termine le dplacement de llment. Si llment est dplac en dehors
 * de lcran, la fentre ne dfile pas. Cette implmentation fonctionne 
 * avec les modles dvnements du DOM Niveau 2 et dIE.
 * 
 * Arguments :
 *
 *   elementDeplace : llment qui a reu lvnement mousedown ou un
 *     lment conteneur. Il doit tre positionn de manire absolue.
 *     Ses valeurs style.left et style.top sont modifies en fonction
 *     du glissement opr par utilisateur.
 *
 *   evenement : lobjet Event de lvnement mousedown.
 **/
function startDrag(boundingElement, moveHandler, evenement) {

    // Enregistrer les gestionnaires qui rpondent aux vnements mousemove
    // et  lvnement mouseup qui vient aprs cet vnement mousedown.
    if (document.addEventListener) {  // Modle dvnements du DOM Niveau 2.
        // Enregistrer des gestionnaires dvnements avec capture.
        document.addEventListener("mousemove", moveHandler, true);
        document.addEventListener("mouseup", gestionnaireRelachement, true);
    }
    else if (document.attachEvent) {  // Modle dvnements dIE 5+.
        // Dans le modle dvnements dIE, les vnements sont capturs
        // par un appel  setCapture() sur llment.
        boundingElement.setCapture();
        boundingElement.attachEvent("onmousemove", moveHandler);
        boundingElement.attachEvent("onmouseup", gestionnaireRelachement);
        // Traiter la perte de la capture de la souris comme 
        // un vnement mouseup.
        boundingElement.attachEvent("onlosecapture", gestionnaireRelachement);
    }
    else {  // Modle dvnements dIE 4.
        // Dans IE 4, nous ne pouvons utiliser attachEvent() ou setCapture(),
        // nous fixons donc directement les gestionnaires dvnements dans
        // lobjet de document et esprons que les vnements de la souris 
        // dont nous avons besoin se propageront.
        var ancienGestDeplacement = document.onmousemove; // Utilis par gestionnaireRelachement().
        var ancienGestRelachement = document.onmouseup;
        document.onmousemove = moveHandler;
        document.onmouseup = gestionnaireRelachement;
    }

    // Puisque nous traitons lvnement, ne laisser personne dautre le voir.
    if (evenement.stopPropagation)
        evenement.stopPropagation();          // DOM Niveau 2.
    else evenement.cancelBubble = true;       // IE.

    // Empcher les actions par dfaut.
    if (evenement.preventDefault)
        evenement.preventDefault();           // DOM Niveau 2.
    else evenement.returnValue = false;       // IE.

    /**
     * Voici le gestionnaire qui capture lvnement final mouseup qui
     * se produit  la fin de lopration de glissement.
     **/
    function gestionnaireRelachement(e) {
        if (!e) e = window.event;  // Modle dvnements dIE.

        // Dsenregistrer les gestionnaires dvnements avec capture.
        if (document.removeEventListener) {  // Modle dvnements du DOM.
            document.removeEventListener("mouseup", gestionnaireRelachement, true);
            document.removeEventListener("mousemove", moveHandler, true);
        }
        else if (document.detachEvent) {     // Modle dvnements dIE 5+.
            boundingElement.detachEvent("onlosecapture", gestionnaireRelachement);
            boundingElement.detachEvent("onmouseup", gestionnaireRelachement);
            boundingElement.detachEvent("onmousemove", moveHandler);
            boundingElement.releaseCapture();
        }
        else {  // Modle dvnements dIE 4.
            // Restaurer les gestionnaires dorigine, si prsents.
            document.onmouseup = ancienGestRelachement;
            document.onmousemove = ancienGestDeplacement;
        }

        // Empcher la propagation de lvnement.
        if (e.stopPropagation) e.stopPropagation();  // DOM Niveau 2.
        else e.cancelBubble = true;                  // IE.
    }
}