/**
 * Variables contenant les rfrences aux structures de fentres du contenu
 * des diffrents onglets.
 */
var tabExempleSAW;
var tabGlossaireSAW;
var tabWebSAW;
var tabHelpSAW;
var tabAboutSAW;
var tabBrowserSAW;
var tabConsoleSAW;
var recipeCodeSAW;

/**
 * Cre la disposition initiale de l'interface.
 */
function packUI() {
	// Calcul de la hauteur et de la largeur du contenu d'un onglet.
	var bodyEle = document.getElementById("tab-pane-1");
	var wOutCont = bodyEle.offsetWidth;
	var hOutCont = bodyEle.offsetHeight;
	var rowCont = document.getElementById("tab-row");
	hOutCont -= rowCont.offsetHeight;
	
	tabExempleSAW.pack(wOutCont, hOutCont, false, true);
	tabGlossaireSAW.pack(wOutCont, hOutCont, false, true);
	tabWebSAW.pack(wOutCont, hOutCont, false, true);
	tabHelpSAW.pack(wOutCont, hOutCont, false, true);
	tabAboutSAW.pack(wOutCont, hOutCont, false, true);

	// Disposer le deuxime onglet.
	pack_tabPane2(false)	
}

function pack_tabPane2(force) {
	// Calcul de la hauteur et de la largeur du contenu d'un onglet.
	var bodyEle = document.getElementById("tab-pane-2");
	var wOutCont = bodyEle.offsetWidth;
	var hOutCont = bodyEle.offsetHeight;
	var rowCont = document.getElementById("tab-row");
	hOutCont -= rowCont.offsetHeight;

	tabBrowserSAW.pack(wOutCont, hOutCont, force, true);
	tabConsoleSAW.pack(wOutCont, hOutCont, force, true);
}

/**
 * Redimensionne l'interface en fonction de la fentre du navigateur.
 */
function resizeUI() {
	// Calcul de la hauteur et de la largeur du contenu d'un onglet.
	var bodyEle = document.getElementById("tab-pane-1");
	var wOutCont = bodyEle.offsetWidth;
	var hOutCont = bodyEle.offsetHeight;
	var rowCont = document.getElementById("tab-row");
	hOutCont -= rowCont.offsetHeight;
	
	tabExempleSAW.resize(wOutCont, hOutCont, false);
	tabGlossaireSAW.resize(wOutCont, hOutCont, false);
	tabWebSAW.resize(wOutCont, hOutCont, false);
	tabHelpSAW.resize(wOutCont, hOutCont, false);
	tabAboutSAW.resize(wOutCont, hOutCont, false);

	resize_tabPane2();
}	

function resize_tabPane2() {
	// Calcul de la hauteur et de la largeur du contenu d'un onglet.
	var bodyEle = document.getElementById("tab-pane-2");
	var wOutCont = bodyEle.offsetWidth;
	var hOutCont = bodyEle.offsetHeight;
	var rowCont = document.getElementById("tab-row");
	hOutCont -= rowCont.offsetHeight;
	
	tabBrowserSAW.resize(wOutCont, hOutCont, false);
	tabConsoleSAW.resize(wOutCont, hOutCont, false);
}

/**
 * Gestion de l'ouverture du document. On cre les diffrents div de
 * l'interface  onglets.
 */
window.onload = function() {
	//window.resizeTo(800, 600);
	
	// S'assurer que les onglets sont bien crs.
	setupAllTabs();

	// Crer la fentre pour l'onglet Exemple.
	tabExempleSAW = new SAWindow2("container-book2-tab",
								  "book2-window",  "tabExample",
					 		 	  "book2-menu",    "tabExampleMenu",
						 		  "book2-content", "tabExampleContent",
								  SAWindow2.STATIC_TOP);
	tabExempleSAW.addToTop("tabExampleMenuCont");

	recipeCodeSAW = new SAWindow2("book2-content",
							  "sub2-window", "recipeMainPanel",
				 		 	  "sub2-top",    "recipeTocDesc",
					 		  "sub2-bottom", "recipeExec",
							  SAWindow2.RESIZE_VERTICAL);
	recipeCodeSAW.setTopMin(40);
	recipeCodeSAW.setBotMin(90);
	recipeCodeSAW.addToTop("book2-toppanel");
	recipeCodeSAW.addToBot("book2-botpanel");
	recipeCodeSAW.addSubPack(pack_tabPane2);
	recipeCodeSAW.addSubResize(resize_tabPane2);

	// Crer la fentre pour l'onglet Glossaire.
	tabGlossaireSAW = new SAWindow2("container-glo-tab",
								  "glo-window",  "tabGlossaire",
					 		 	  "glo-menu",    "tabGlossaireMenu",
						 		  "glo-content", "tabGlossaireContent",
								  SAWindow2.STATIC_TOP);
	tabGlossaireSAW.addToTop("glossaire-menu");
	tabGlossaireSAW.addToBot("glossaire-content");

	// Crer la fentre pour l'onglet Web.
	tabWebSAW = new SAWindow2("container-web-tab",
								  "web-window",  "tabWeb",
					 		 	  "web-menu",    "tabWebMenu",
						 		  "web-content", "tabWebContent",
								  SAWindow2.STATIC_TOP);
	tabWebSAW.addToBot("web-subcontent");

	// Crer la fentre pour l'onglet Glossaire.
	tabHelpSAW = new SAWindow2("container-help-tab",
								  "help-window",  "tabHelp",
					 		 	  "help-menu",    "tabHelpMenu",
						 		  "help-content", "tabHelpContent",
								  SAWindow2.STATIC_TOP);
	tabHelpSAW.addToTop("help-submenu");
	tabHelpSAW.addToBot("help-subcontent");

	// Crer la fentre pour l'onglet  propos.
	tabAboutSAW = new SAWindow2("container-about-tab",
								  "about-window",  "tabAbout",
					 		 	  "about-menu",    "tabAboutMenu",
						 		  "about-content", "tabAboutContent",
								  SAWindow2.STATIC_TOP);
	tabAboutSAW.addToBot("about-subcontent");

	// Crer la fentre pour l'onglet Browser.
	tabBrowserSAW = new SAWindow2("container-browser-tab",
								  "browser-window",  "tabBrowser",
					 		 	  "browser-menu",    "tabBrowserMenu",
						 		  "browser-content", "tabBrowserContent",
								  SAWindow2.STATIC_TOP);
	tabBrowserSAW.addToTop("tabBrowserMenuCont");


	// Crer la fentre pour l'onglet Console.
	tabConsoleSAW = new SAWindow2("container-console-tab",
								  "console-window",  "tabConsole",
					 		 	  "console-menu",    "tabConsoleMenu",
						 		  "console-content", "tabConsoleContent",
								  SAWindow2.STATIC_TOP);
	tabConsoleSAW.addToTop("tabConsoleMenuCont");
	
	// Construire l'interface.
	packUI();
	
	// Lire le contenu du livre.
	var book = new SABook("CTMCP");
	book.loadXML("book");
	book.toHTMLToc(document.getElementById("book2-toc"), document.getElementById("book2-recipe"));
	
	// Vider la zone de saisie du code (FF garde le texte si on appuie sur Actualiser).
	clearCodeEntry();
	
	//startOz();
	//	helloOz();
}

/**
 * Vider la zone de saisie du code .
 */
function clearCodeEntry() {
	var c = document.getElementById("codeEntry");
	c.value = "";
}
	

/**
 * Redimensionner les diffrents onglets lorsque la fentre du navigateur
 * est redimensionne.
 */
window.onresize = function() {
	resizeUI();
}

/**
 *
 */
function newExample() {
	/*
	var bod = parent.logFrame.document.getElementsByTagName("body")[0];
	bod.innerHTML = document.getElementById("container-book2-tab").innerHTML;
	*/
	
	var newwind = window.open("sublabo.html", "sublab");
}

/**
 *
 */
function onlyRecipe() {
	recipeCodeSAW.repack(SAWindow2.ONLY_TOP);
}
function onlyCode() {
	recipeCodeSAW.repack(SAWindow2.ONLY_BOTTOM);
}
function showBoth() {
	recipeCodeSAW.repack(SAWindow2.RESIZE_VERTICAL);
}


/**
 * Callbacks de TabPane.
 */
function tabPaneHide(ele) {

	var bodyEle = document.getElementById("tab-pane-1");
	var wOutCont = bodyEle.offsetWidth;
	var hOutCont = bodyEle.offsetHeight;
	var rowCont = document.getElementById("tab-row");
	hOutCont -= rowCont.offsetHeight;

	// On sauvegarde la taille actuelle de l'onglet qui va tre masqu.
	if (ele.id == "container-book2-tab" && tabExempleSAW != null)
		tabExempleSAW.saveSize(wOutCont, hOutCont);
	if (ele.id == "container-glo-tab" && tabGlossaireSAW != null)
		tabGlossaireSAW.saveSize(wOutCont, hOutCont);
	if (ele.id == "container-web-tab" && tabWebSAW != null)       
		tabWebSAW.saveSize(wOutCont, hOutCont);
	if (ele.id == "container-help-tab" && tabHelpSAW != null)     
		tabHelpSAW.saveSize(wOutCont, hOutCont);
	if (ele.id == "container-about-tab" && tabAboutSAW != null)   
		tabAboutSAW.saveSize(wOutCont, hOutCont);

	var bodyEle = document.getElementById("tab-pane-2");
	var wOutCont = bodyEle.offsetWidth;
	var hOutCont = bodyEle.offsetHeight;
	var rowCont = document.getElementById("tab-row");
	hOutCont -= rowCont.offsetHeight;

	// On sauvegarde la taille actuelle de l'onglet qui va tre masqu.
	if ((ele.id == "container-book2-tab" || ele.id == "container-browser-tab") && tabBrowserSAW != null)
		tabBrowserSAW.saveSize(wOutCont, hOutCont);
	if ((ele.id == "container-book2-tab" || ele.id == "container-console-tab") && tabConsoleSAW != null)
		tabConsoleSAW.saveSize(wOutCont, hOutCont);
}


function tabPaneShow(ele) {

	var bodyEle = document.getElementById("tab-pane-1");
	var wOutCont = bodyEle.offsetWidth;
	var hOutCont = bodyEle.offsetHeight;
	var rowCont = document.getElementById("tab-row");
	hOutCont -= rowCont.offsetHeight;

	// On pack le contenu de l'onglet qui va tre affich. Si cela avait dj t fait, 
	// pack() ne le refait pas. Dans ce cas, on synchronise la fentre avec la nouvelle 
	// taille potentielle du navigateur.
	if (ele.id == "container-book2-tab" && tabExempleSAW != null) {
		if (!tabExempleSAW.pack(wOutCont, hOutCont, false, true)) {
			tabExempleSAW.resize(wOutCont, hOutCont, true);
		}
	}
	if (ele.id == "container-glo-tab" && tabGlossaireSAW != null) {
		if (!tabGlossaireSAW.pack(wOutCont, hOutCont, false, true)) {
			tabGlossaireSAW.resize(wOutCont, hOutCont, true);
		}
	}
	if (ele.id == "container-web-tab" && tabWebSAW != null) {
		if (!tabWebSAW.pack(wOutCont, hOutCont, false, true)) {
			tabWebSAW.resize(wOutCont, hOutCont, true);
		}
	}
	if (ele.id == "container-help-tab" && tabHelpSAW != null) {
		if (!tabHelpSAW.pack(wOutCont, hOutCont, false, true)) {
			tabHelpSAW.resize(wOutCont, hOutCont, true);
		}
	}
	if (ele.id == "container-about-tab" && tabAboutSAW != null) {
		if (!tabAboutSAW.pack(wOutCont, hOutCont, false, true)) {
			tabAboutSAW.resize(wOutCont, hOutCont, true);
		}
	}
	
	var bodyEle = document.getElementById("tab-pane-2");
	var wOutCont = bodyEle.offsetWidth;
	var hOutCont = bodyEle.offsetHeight;
	var rowCont = document.getElementById("tab-row");
	hOutCont -= rowCont.offsetHeight;

	// On pack le contenu de l'onglet qui va tre affich. Si cela avait dj t fait, 
	// pack() ne le refait pas. Dans ce cas, on synchronise la fentre avec la nouvelle 
	// taille potentielle du navigateur.
	if ((ele.id == "container-book2-tab" || ele.id == "container-browser-tab") && tabBrowserSAW != null) {
		if (!tabBrowserSAW.pack(wOutCont, hOutCont, false, true)) {
			tabBrowserSAW.resize(wOutCont, hOutCont, true);
		}
	}
	if ((ele.id == "container-book2-tab" || ele.id == "container-console-tab") && tabConsoleSAW != null) {
		if (!tabConsoleSAW.pack(wOutCont, hOutCont, false, true)) {
			tabConsoleSAW.resize(wOutCont, hOutCont, true);
		}
	}

}
