/*
 * ScienceActive's book
 *
 * This script was created by Herv Soulard(Herve.Soulard@sienceactive.com)
 * Copyright 2007
 * 
 * Version: 1.0
 * Created: 2007-06-23	First working version
 *
 */

///////////////////////////////////////////////////////////////////////////////////
// 
// Variables globales.
//

var theBook;

var theRecipe;

///////////////////////////////////////////////////////////////////////////////////
// 
// Fonctions outils.
//
function getCDATAContent(element) {
	var content = "Indfini";
	for (var i = 0; i < element.childNodes.length; i++) {
		var tmp = element.childNodes[i];
		if (tmp.nodeType == /* CDATA_SECTION_NODE */ 4) {
			content = tmp.nodeValue;
		}
	}
	return content;
}

/**
 * Dvelopper rduire le contenu d'un niveau de la table des matires.
 * Ne fonctionne qu'avec un strict respect de l'arborescence.
 */
function displayChapToc(chapNum, mode) {
	for (var i = 0; i < theBook.chapters.length; i++) {
		var chap = theBook.chapters[i + 1];
		if ((chap != null) && (chap.num == chapNum)) {
			chap.displayTocEntry(mode);
		}
	}
}
function displaySectToc(chapNum, sectNum, mode) {
	var chap = theBook.chapters[chapNum];
	for (var i = 0; i < chap.sections.length; i++) {
		var sect = chap.sections[i + 1];
		if ((sect != null) && (sect.num == sectNum)) {
			sect.displayTocEntry(mode);
		}
	}
}
 
function openCloseAll(mode) {
	theBook.displayTocEntry(mode);
	
	// Ce code permet de rgler un problme d'affichage sous IE 7.
	// Pourquoi ????? Je ne sais pas !!!!!
	var type = recipeCodeSAW.type;
	if (type == SAWindow2.ONLY_TOP || type == SAWindow2.ONLY_BOTTOM) {
		showBoth();
	} else {
		onlyRecipe();
	}
	recipeCodeSAW.repack(type);
}

/**
 *
 * <div class="recipeTitle"></div>
 * <div class="recipeDesc"></div>
 * <div class="recipeCode" onclick="runCode()"></div>
 */
function displayRecipe(dest, recipe) {

	theRecipe = recipe;

	// Supprimer l'ancienne recette affiche.
	while (dest.hasChildNodes()) {
		dest.removeChild(dest.firstChild);
	}
	
	// Ajouter un <div> conteneur global.
	var bigDiv = document.createElement("div");
	dest.appendChild(bigDiv);
	dest = bigDiv;
	
	var titleCont = document.createElement("div");
	titleCont.className = "recipeTitle";

	var descCont = document.createElement("div");
	descCont.className = "recipeDesc";
	var desc = document.createElement("div");
	descCont.appendChild(desc);

	if (recipe.shortCode != "") {
		var codeCont = document.createElement("div");
		codeCont.className = "recipeCode";
		codeCont.onclick = function() { piphook_loadCode(recipe); };
		codeCont.onmousemove = ejs_context_position;
		codeCont.oncontextmenu = ejs_context_open;
		document.onclick = ejs_context_close;

		var shortCode = document.createElement("pre");
		codeCont.appendChild(shortCode);

		if (isIE()) {
			// Remplacer les \n par des \r.
			var foo = document.createTextNode(recipe.shortCode.replace(/\n/g, "\r"));
			shortCode.appendChild(foo);
		} else {
			var foo = document.createTextNode(recipe.shortCode);
			shortCode.appendChild(foo);
		}

	}
	
	var titleStr = recipe.chap + "." + recipe.sect + "." + recipe.localNum + ". " + recipe.title;
	if (recipe.fromBook == "yes") {
		titleCont.innerHTML = '<img src="img/book.gif" hspace="5" vspace="5" border="0" align="right" />' + titleStr;
	} else {
		titleCont.innerHTML = titleStr;
	}

	descCont.innerHTML = recipe.description;

	dest.appendChild(titleCont);
	dest.appendChild(descCont);
	if (recipe.shortCode != "") {
		dest.appendChild(codeCont);
	}
}

/** 
 *
 */
function piphook_showMenu(e) {
	if (!e) e = window.event;
	var recipeMenu = document.getElementById("recipeMenu");
	if (recipeMenu == null) {
		return;
	}
	
	var debutX = e.clientX, debutY = e.clientY;
	// Position dorigine (en coordonnes de document) de la barre.
    var origX = 0, origY = 0;
	// Tenir compte des dcalages.
	var deltaX = debutX - origX, deltaY = debutY - origY;	
	
	recipeMenu.style.display = "block";
	recipeMenu.style.top = deltaY + 'px';
	recipeMenu.style.left = deltaX + 'px';
	
	
}
function piphook_hideMenu(e) {
	if (!e) e = window.event;
	alert("hide " + e);
}
 

/**
 * Charger le code  excuter dans la zone d'dition.
 */
function piphook_loadCode(recipe) {
	var code = document.getElementById("codeEntry");
	if (code != null) {
		switchToBrowser();
		code.value = recipe.fullCode;
	}
}
function piphook_loadShortCode(recipe) {
	var code = document.getElementById("codeEntry");
	if (code != null) {
		switchToBrowser();
		code.value = recipe.shortCode;
	}
}
function piphook_appendCode(recipe) {
	var code = document.getElementById("codeEntry");
	if (code != null) {
		switchToBrowser();
		code.value = code.value + recipe.shortCode;
	}
}

/**
 * Basculer sur l'onglet Browser.
 */
function switchToBrowser() {
	var tab = document.getElementById("browser-tab");
	tab.onclick();
}
/**
 * Basculer sur l'onglet Console.
 */
function switchToConsole() {
	var tab = document.getElementById("console-tab");
	tab.onclick();
}

/**
 * Excuter le code contenu dans la zone de saisie.
 */
function runCode() {
	var opi = document.getElementById("opiApplet");
	var code = document.getElementById("codeEntry");
	if ((opi != null) && (code != null)) {
		switchToBrowser();
		opi.execute(code.value, false);
	}
}

/**
 * Excuter le code slectionn dans la zone de saisie.
 */
function runSelectedCode() {
	var opi = document.getElementById("opiApplet");
	var code = document.getElementById("codeEntry");
	if ((opi != null) && (code != null)) {
		var sel;
		if (isIE()) {
			sel = document.selection.createRange().text;
		} else {
			var start = code.selectionStart;
			var end = code.selectionEnd;
			sel = code.value.substring(start, end);
		}
		switchToBrowser();
		opi.execute(sel, false);
	}
}

/**
 * Charger un fichier contenant du code Oz.
 *
 * Le chargement se fait dans la fonction 'brower_openFile()' appele par l'applet.
 */
function openFile() {
	var opi = document.getElementById("opiApplet");
	if (opi != null) {
		opi.openFile();
	}
}

/**
 * Enregistrer le code oz dans un fichier.
 */
function saveFile() {
	var opi = document.getElementById("opiApplet");
	var code = document.getElementById("codeEntry");
	if ((opi != null) && (code != null)) {
		opi.saveFile(code.value);
	}
}


/**
 * Ouvrir le Oz Panel.
 */
function openOzPanel() {
	var opi = document.getElementById("opiApplet");
	if (opi != null) {
		opi.openOzPanel();
	}
}

/**
 * Redmarrer Oz.
 */
function restartOz() {
	clearBrowser();
	clearConsole();
	switchToBrowser();
	
	var opi = document.getElementById("opiApplet");
	if (opi != null) {
		opi.restartOz();
		//helloOz();
	}
}

/**
 * Dmarrer Oz.
 */
function startOz() {
	clearBrowser();
	clearConsole();
	switchToBrowser();
	
	var opi = document.getElementById("opiApplet");
	if (opi != null) {
		opi.startOz();
	}
}


/**
 * Saluer Oz.
 */
function helloOz() {
	var opi = document.getElementById("opiApplet");
	if (opi != null) {
		opi.hello();
	}
}


/**
 * Effacer le contenu de la fentre du browser.
 */
function clearBrowser() {
	var opi = document.getElementById("opiApplet");
	if (opi != null) {
		opi.clear();
	}
}

/**
 * Effacer le contenu de la fentre de la console.
 */
function clearConsole() {
	console_clear();
}


///////////////////////////////////////////////////////////////////////////////////
// The constructor for a Book.
//
function SABook(title) {
	this.title = title;
	this.chapters = new Array();
	
	theBook = this;
}

SABook.prototype = {
	
	addChapter: function(chapter) {
		var num = chapter.num;
		this.chapters[num] = chapter;
	},
	
	getChapter: function(num) {
		return this.chapters[num];
	},
	
	displayTocEntry: function(mode) {
		for (var i = 0; i < this.chapters.length; i++) {
			var chap = this.chapters[i + 1];
			if (chap != null) {
				chap.displayTocEntry(mode);
				for (var j = 0; j < chap.sections.length; j++) {
					var sect = chap.sections[j + 1];
					if (sect != null) {
						sect.displayTocEntry(mode);
					}
				}
			}
		}		
	},
	
	toHTMLToc: function(root, dest) {
		var thisObj = this;
		
		// Ajouter les noeuds du livre.
		var chaptersRoot = root;
		
		var menu = document.createElement("div");
		menu.className = "toc-minimenu";
		root.appendChild(menu);
		
		var minimenu = document.createElement("a");
		minimenu.className = "toc-minimenu-button toleft";
		minimenu.href = "javascript: void 0;";
		minimenu.appendChild(document.createTextNode("Dvelopper tout"));
		if (isIE()) {
			minimenu.onclick = function () { openCloseAll(1)};
		} else {
			minimenu.setAttribute("onclick", "openCloseAll(1)");
		}	
		menu.appendChild(minimenu);

		minimenu = document.createElement("a");
		minimenu.className = "toc-minimenu-button toright";
		minimenu.href = "javascript: void 0;";
		minimenu.appendChild(document.createTextNode("Rduire tout"));
		if (isIE()) {
			minimenu.onclick = function () { openCloseAll(2)};
		} else {
			minimenu.setAttribute("onclick", "openCloseAll(2)");
		}	
		menu.appendChild(minimenu);


		for (var i = 0; i < this.chapters.length; i++) {
			// Ajouter les noeuds du chapitre.
			var chap = this.chapters[i];
			if (chap) {
				chap.toHTMLToc(chaptersRoot, dest);
			}
		}
	},



	/**
	 * 'file' contient uniquement les dfinitions de chapitres et de sections.
	 */
	loadXML: function(file) {

		var xmlDoc = XML_SA.charger(file + ".xml");

		// Parcourir tous les chapitres.
		//
		var allChaps = xmlDoc.getElementsByTagName("chapter");
		for (var ci = 0; ci < allChaps.length; ci++) {
			var chapTag = allChaps[ci];
			var chapNumTag = chapTag.getElementsByTagName("chapNum")[0];
			var chapTitleTag = chapTag.getElementsByTagName("chapTitle")[0];
			var chapNum = 0;
			var chapTitle = "";
			if (chapNumTag != null) {
				chapNum = parseInt(chapNumTag.firstChild.data);
			}
			if (chapTitleTag != null) {
				chapTitle = chapTitleTag.firstChild.data;
			}
			
			var chap = new SAChapter(chapNum, chapTitle);
			this.addChapter(chap);

			// Parcourir toutes les sections.
			var allSections = chapTag.getElementsByTagName("section");
			for (var si = 0; si < allSections.length; si++) {
				var sectTag = allSections[si];
				var sectNumTag = sectTag.getElementsByTagName("sectNum")[0];
				var sectTitleTag = sectTag.getElementsByTagName("sectTitle")[0];
				var sectNum = 0;
				var sectTitle = "";
				if (sectNumTag != null) {
					sectNum = parseInt(sectNumTag.firstChild.data);
				} else {
					continue;
				}
				if (sectTitleTag != null) {
					sectTitle = sectTitleTag.firstChild.data;
				} else {
					continue;
				}
				
				var sect = new SASection(sectNum, sectTitle, chapNum);
				chap.addSection(sect);
			}
			
			// Parcourir toutes les recettes.
			var recXmlDoc = XML_SA.charger(file + "_recipes_chap" + chapNum + ".xml");
			var allRecipes = recXmlDoc.getElementsByTagName("recipe");
			var curSect = 0;
			var curRec = 1;
			for (var ri = 0; ri < allRecipes.length; ri++) {
				var recTag = allRecipes[ri];
				var recNumTag = recTag.getElementsByTagName("recNum")[0];
				var recTitleTag = recTag.getElementsByTagName("recTitle")[0];
				var sectRefTag = recTag.getElementsByTagName("sectRef")[0];
				var recNum = 0;
				var recTitle = "";
				var sectRef = 0;
				if (recNumTag != null) {
					recNum = parseInt(recNumTag.firstChild.data);
				} else {
					continue;
				}
				if (recTitleTag != null) {
					recTitle = recTitleTag.firstChild.data;
				} else {
					continue;
				}
				if (sectRefTag != null) {
					sectRef = parseInt(sectRefTag.firstChild.data);
				} else {
					continue;
				}
				
				var rec = new SARecipe(recNum, recTitle, chapNum, sectRef);
				var sect = chap.getSection(sectRef);
				
				// Dterminer le n de la recette dans sa section.
				if (sect.num != curSect) {
					curSect = sect.num;
					curRec = 1;
				} else {
					curRec += 1;
				}
				rec.setLocalNum(curRec);
								
				// Ajouter les autres lments d'un recette.
				var descTag = recTag.getElementsByTagName("description")[0];
				var shortCodeTag = recTag.getElementsByTagName("shortCode")[0];
				var fullCodeTag = recTag.getElementsByTagName("fullCode")[0];
				var fromBookTag = recTag.getElementsByTagName("fromBook")[0];

				if (descTag != null) {
					rec.setDescription(getCDATAContent(descTag));
				}

				if (shortCodeTag != null) {
					rec.setShortCode(getCDATAContent(shortCodeTag));
				}

				if (fullCodeTag != null) {
					rec.setFullCode(getCDATAContent(fullCodeTag));
				}

				if (fromBookTag != null) {
					rec.setFromBook(fromBookTag.firstChild.data);
				} else {
					rec.setFromBook("no");
				}


				// Ajouter la recette  sa section.
				if (sect) {
					sect.addRecipe(rec);
				}
			}
		}
	}
}

///////////////////////////////////////////////////////////////////////////////////
// The constructor for a Chapter.
//
function SAChapter(num, title) {
	this.num = num;
	this.title = title;
	this.sections = new Array();
	this.tocL1Content = null;
	this.tocL1Icon = null;
}

SAChapter.prototype = {
	
	addSection:	function(section) {
		var num = section.num;
		this.sections[num] = section;
	},
	
	getSection: function(num) {
		return this.sections[num];
	},
	
	displayTocEntry: function(mode) {
		if (this.sections.length == 0) {
			return;
		}
		
		if (mode == 0) {
			// Mode bascule
			if (this.tocL1Content.style.display == "none") {
				this.tocL1Content.style.display = "block";
				this.tocL1Icon.src='img/menu-minus.gif';
			} else {
				this.tocL1Content.style.display = "none";
				this.tocL1Icon.src='img/menu-plus.gif';
			}
		} else if (mode == 1) {
			// Ouverture force.
			this.tocL1Content.style.display = "block";
			this.tocL1Icon.src='img/menu-minus.gif';
		} else if (mode == 2) {
			// Fermeture force.
			this.tocL1Content.style.display = "none";
			this.tocL1Icon.src='img/menu-plus.gif';
		}
	},
	
	toHTMLToc: function(root, dest) {
		var thisObject = this;
															// <div class="toc-l1">
		var tocL1 = document.createElement("div");		
		tocL1.className = "toc-l1";
															//   <div class="toc-l1-entry">
		var tocL1Entry= document.createElement("div");		
		tocL1Entry.className = "toc-l1-entry";
		
															//     <div class="toc-l1-icon">
					  										//       <img src="img/menu-minus.gif" onclick="toggleDisplay(this, 1, 2)">
															//     </div>
		var tocL1Icon = document.createElement("div");	
		tocL1Icon.className = "toc-l1-icon";
		tocL1Icon.innerHTML = "<img src='img/menu-plus.gif' onclick='displayChapToc("+thisObject.num+", 0)' />";
		tocL1Entry.appendChild(tocL1Icon);

															//     <div class="toc-l1-ref">
															//       <div class="toc-l1-refNum">
															//         <a href="javascript:void 0;">10</a>
															//       </div>
															//       <div class="toc-l1-refTitle">
															//         <a href="javascript:void 0;">Titre chapitre</a>
															//       </div>
															//     </div>
		var tocL1Ref = document.createElement("div");
		tocL1Ref.className = "toc-l1-ref";
		if (isIE()) {
			tocL1Ref.onclick = function () { displayChapToc(thisObject.num, 0)};
		} else {
			tocL1Ref.setAttribute("onclick", "displayChapToc("+thisObject.num+", 0)");
		}	
		var tocL1RefNum  = document.createElement("div");
		tocL1RefNum.className = "toc-l1-refNum";
		var tocL1RefNumA = document.createElement("a");	
		tocL1RefNumA.href = "javascript: void 0;";
		tocL1RefNumA.appendChild(document.createTextNode(this.num + "."));
		tocL1RefNum.appendChild(tocL1RefNumA);						
		var tocL1RefTitle  = document.createElement("div");
		tocL1RefTitle.className = "toc-l1-refTitle";
		var tocL1RefTitleA = document.createElement("a");	
		tocL1RefTitleA.href = "javascript: void 0;";
		tocL1RefTitleA.appendChild(document.createTextNode(this.title));
		tocL1RefTitle.appendChild(tocL1RefTitleA);
		tocL1Ref.appendChild(tocL1RefNum);
		tocL1Ref.appendChild(tocL1RefTitle);
		tocL1Entry.appendChild(tocL1Ref);
															//   </div>
		tocL1.appendChild(tocL1Entry);
		
															//   <div class="toc-l1-content">
		var tocL1Content = document.createElement("div");
		tocL1Content.className = "toc-l1-content";
		tocL1Content.style.display = "none";
		tocL1.appendChild(tocL1Content);

		this.tocL1Content = tocL1Content;
		this.tocL1Icon = tocL1Icon.firstChild;
		root.appendChild(tocL1);

		for (var i = 0; i < this.sections.length; i++) {
			// Ajouter les noeuds de la section.
			var sect = this.sections[i];
			if (sect) {
				sect.toHTMLToc(tocL1Content, dest);
			}
		}
	}	
}

///////////////////////////////////////////////////////////////////////////////////
// The constructor for a Section.
//
function SASection(num, title, chap) {
	this.num = num;
	this.title = title;
	this.chap = chap;
	this.recipes = new Array();
	this.tocL2Content = null;
	this.tocL2Icon = null;
}

SASection.prototype = {
	
	addRecipe:	function(recipe) {
		var num = recipe.num;
		this.recipes[num] = recipe;
	},
	
	getRecipe: function(num) {
		return this.recipes[num];
	},
			
	displayTocEntry: function(mode) {
		if (this.recipes.length == 0) {
			return;
		}

		if (mode == 0) {
			// Mode bascule
			if (this.tocL2Content.style.display == "none") {
				this.tocL2Content.style.display = "block";
				this.tocL2Icon.src='img/menu-minus.gif';
			} else {
				this.tocL2Content.style.display = "none";
				this.tocL2Icon.src='img/menu-plus.gif';
			}
		} else if (mode == 1) {
			// Ouverture force.
			this.tocL2Content.style.display = "block";
			this.tocL2Icon.src='img/menu-minus.gif';
		} else if (mode == 2) {
			// Fermeture force.
			this.tocL2Content.style.display = "none";
			this.tocL2Icon.src='img/menu-plus.gif';
		}
	},

	toHTMLToc: function(root, dest) {
		var thisObject = this;
		
															// <div class="toc-l2">
		var tocL2 = document.createElement("div");		
		tocL2.className = "toc-l2";
															//   <div class="toc-l2-entry">
		var tocL2Entry= document.createElement("div");		
		tocL2Entry.className = "toc-l2-entry";
		
															//     <div class="toc-l2-icon">
					  										//       <img src="img/menu-minus.gif" onclick="toggleDisplay(this, 2, 2)">
															//     </div>
		var tocL2Icon = document.createElement("div");	
		tocL2Icon.className = "toc-l2-icon";
		
		if (this.recipes.length > 0) {
			tocL2Icon.innerHTML = "<img src='img/menu-plus.gif' onclick='displaySectToc("+thisObject.chap+", "+thisObject.num+", 0)' />";
		} else {
			tocL2Icon.innerHTML = "<img src='img/menu-empty.gif' />";
		}
		tocL2Entry.appendChild(tocL2Icon);
															//     <div class="toc-l2-ref">
															//       <div class="toc-l2-refNum">
															//         <a href="javascript:void 0;">10</a>
															//       </div>
															//       <div class="toc-l2-refTitle">
															//         <a href="javascript:void 0;">Titre chapitre</a>
															//       </div>
															//     </div>
		var tocL2Ref = document.createElement("div");
		tocL2Ref.className = "toc-l2-ref";
		if (this.recipes.length > 0) {
			if (isIE()) {
				tocL2Ref.onclick = function () { displaySectToc(thisObject.chap, thisObject.num, 0) };
			} else {
				tocL2Ref.setAttribute("onclick", "displaySectToc("+thisObject.chap+", "+thisObject.num+", 0)");
			}
		}
		var tocL2RefNum  = document.createElement("div");
		tocL2RefNum.className = "toc-l2-refNum";
		var tocL2RefNumA = document.createElement("a");	
		if (this.recipes.length == 0) {
			tocL2RefNumA.className = "toc-ref-empty";
		}
		tocL2RefNumA.href = "javascript: void 0;";
		tocL2RefNumA.appendChild(document.createTextNode(this.num + "."));
		tocL2RefNum.appendChild(tocL2RefNumA);						
		var tocL2RefTitle  = document.createElement("div");
		tocL2RefTitle.className = "toc-l2-refTitle";
		var tocL2RefTitleA = document.createElement("a");	
		if (this.recipes.length == 0) {
			tocL2RefTitleA.className = "toc-ref-empty";
		}
		tocL2RefTitleA.href = "javascript: void 0;";
		tocL2RefTitleA.appendChild(document.createTextNode(this.title));
		tocL2RefTitle.appendChild(tocL2RefTitleA);
		tocL2Ref.appendChild(tocL2RefNum);
		tocL2Ref.appendChild(tocL2RefTitle);
		tocL2Entry.appendChild(tocL2Ref);
															//   </div>
		tocL2.appendChild(tocL2Entry);
		
															//   <div class="toc-l2-content">
		var tocL2Content = document.createElement("div");
		tocL2Content.className = "toc-l2-content";
		tocL2Content.style.display = "none";
		tocL2.appendChild(tocL2Content);


		this.tocL2Content = tocL2Content;
		this.tocL2Icon = tocL2Icon.firstChild;
		root.appendChild(tocL2);
		
		for (var i = 0; i < this.recipes.length; i++) {
			// Ajouter les noeuds de la recette.
			var rec = this.recipes[i];
			if (rec) {
				rec.toHTMLToc(tocL2Content, dest);
			}
		}
		
	}
}

///////////////////////////////////////////////////////////////////////////////////
// The constructor for a Recipe.
//
function SARecipe(num, title, chap, sect) {
	this.num = num;
	this.title = title;
	this.chap = chap;
	this.sect = sect;
	this.localNum = 0;
	this.description = "";
	this.shortCode = "";
	this.fullCode = "";
	this.fromBook = "";
}

SARecipe.prototype = {
	
	setFromBook: function(fromBook) {
		this.fromBook = fromBook;
	},

	setLocalNum: function(num) {
		this.localNum = num;
	},

	setDescription: function(desc) {
		this.description = desc;
	},
	
	setShortCode: function(shortCode) {
		// Supprimer les (potentiels) sauts de ligne de dbut.
		if (shortCode.charCodeAt(0) == 10) {
			shortCode = shortCode.substr(1);
		}
		this.shortCode = shortCode;
	},
	
	setFullCode: function(fullCode) {
		this.fullCode = fullCode;
	},


	toHTMLToc: function(root, dest) {
		var oThis = this;
		
															// <div class="toc-l3">
		var tocL3 = document.createElement("div");		
		tocL3.className = "toc-l3";
															//   <div class="toc-l3-entry">
		var tocL3Entry= document.createElement("div");		
		tocL3Entry.className = "toc-l3-entry";
		
															//     <div class="toc-l3-ref">
															//       <div class="toc-l3-refNum">
															//         <a href="javascript:void 0;">10</a>
															//       </div>
															//       <div class="toc-l3-refTitle">
															//         <a href="javascript:void 0;">Titre recette</a>
															//       </div>
															//     </div>
		var tocL3Ref = document.createElement("div");
		tocL3Ref.className = "toc-l3-ref";
		var tocL3RefNum  = document.createElement("div");
		tocL3RefNum.className = "toc-l3-refNum";
		var tocL3RefNumA = document.createElement("a");	
		tocL3RefNumA.href = "javascript:void 0;";
		tocL3RefNumA.onclick = function () { displayRecipe(dest, oThis); };
		tocL3RefNumA.appendChild(document.createTextNode(this.localNum));
		tocL3RefNum.appendChild(tocL3RefNumA);						
		var tocL3RefTitle  = document.createElement("div");
		tocL3RefTitle.className = "toc-l3-refTitle";
		var tocL3RefTitleA = document.createElement("a");	
		tocL3RefTitleA.href = "javascript:void 0;";
		tocL3RefTitleA.onclick = function () { displayRecipe(dest, oThis); };
		tocL3RefTitleA.appendChild(document.createTextNode(this.title));
		tocL3RefTitle.appendChild(tocL3RefTitleA);
		tocL3Ref.appendChild(tocL3RefNum);
		tocL3Ref.appendChild(tocL3RefTitle);
		tocL3Entry.appendChild(tocL3Ref);
															//   </div>
		tocL3.appendChild(tocL3Entry);
		
															//   <div class="toc-l2-content">
		var tocL3Content = document.createElement("div");
		tocL3Content.className = "toc-l3-content";
		tocL3Content.style.display = "none";
		tocL3.appendChild(tocL3Content);

		root.appendChild(tocL3);
	}
}
