/**
 * xml.js : utilitaires pour crer, charger, analyser, srialiser, transformer
 *          et extraire des donnes  partir de documents XML.
 *
 * Tir du livre JavaScript  La rfrence, 5e dition,
 * de David Flanagan. Copyright 2006 ditions O'Reilly (ISBN : 2-84177-415-5)
 */

// Vrifier que le module n'a pas dj t charg.
var XML_SA;
if (XML_SA && (typeof XML_SA != "object" || XML_SA.NAME))
    throw new Error("L'espace de noms 'XML_SA' existe dj");

// Crer notre espace de noms et quelques mta-informations.
XML_SA = {};
XML_SA.NAME = "XML";     // Nom de cet espace de noms.
XML_SA.VERSION = 1.0;    // Version de cet espace de noms.

/**
 * Crer un nouvel objet Document. Si aucun argument nest donn, le document
 * est vide. Si une balise racine est prcise, le document ne contiendra
 * que cette balise. Si la balise racine possde un prfixe despace de
 * noms, le deuxime argument doit spcifier lURL qui identifie cet espace.
 */
XML_SA.nouveauDocument = function(nomBaliseRacine, urlEspaceDeNoms) {
    if (!nomBaliseRacine) nomBaliseRacine = "";
    if (!urlEspaceDeNoms) urlEspaceDeNoms = "";
    
    if (document.implementation && document.implementation.createDocument) {
        // Procder  la manire du standard W3C.
        return document.implementation.createDocument(urlEspaceDeNoms,
                                                      nomBaliseRacine, null);
    }
    else { // Procder  la manire dIE.
        // Crer un document vide en tant quobjet ActiveX. Si llment 
        // racine nexiste pas, nous navons rien dautre  faire.
        var doc = new ActiveXObject("MSXML2.DOMDocument");

        // Si la balise racine est indique, initialiser le document.
        if (nomBaliseRacine) {
            // Rechercher un prfixe despace de noms.
            var prefixe = "";
            var nomBalise = nomBaliseRacine;
            var p = nomBaliseRacine.indexOf(':');
            if (p != -1) {
                prefixe = nomBaliseRacine.substring(0, p);
                nomBalise = nomBaliseRacine.substring(p+1);
            }

            // Si nous avons un espace de noms, nous devons avoir un prfixe.
            // Sinon, nous oublions tout prfixe.
            if (urlEspaceDeNoms) {
                if (!prefixe) prefixe = "a0"; // Utilis par Firefox.
            }
            else prefixe = "";

            // Crer llment racine (avec lespace de noms facultatif)
            // sous forme dune chane de caractres.
            var texte = "<" + (prefixe?(prefixe+":"):"") +  nomBalise +
                (urlEspaceDeNoms
                 ?(" xmlns:" + prefixe + '="' + urlEspaceDeNoms +'"')
                 :"") +
                "/>";
            // Faire interprter cette chane par le document vide.
            doc.loadXML(texte);
        }
        return doc;
    }
};

/**
 * Tlcharger de manire synchrone le document XML dsign par lURL et 
 * le retourner comme un objet Document.
 */
XML_SA.charger = function(url) {

	if (document.load != null && document.load != undefined || isIE()) {
		// Ici avec Firefox, Opera, IE (possde load, mais test spcial).
    	var docXML = XML_SA.nouveauDocument();  
	    docXML.async = false;  // Nous voulons un tlchargement synchrone.
	   	docXML.load(url);      // Charger et analyser.
	    return docXML;         // Retourner le document.
	} else {
		// Ici avec Safari.
		var docXML = null;
	   	var requete = HTTP.nouvelleRequete();
    	requete.open("GET", url, false);
	    requete.send(null);
		if (requete.status == 0 || requete.status == 200) {
			docXML = requete.responseXML;
		}
		return docXML;
	}
};

/**
 * Tlcharger de manire asynchrone et analyser le document XML dsign
 * par lURL. Lorsque le document est prt, le passer  la fonction de 
 * rappel indique. Cette fonction retourne immdiatement, sans valeur 
 * de retour.
 */
XML_SA.chargerAsynchrone = function(url, rappel) {
    var docXML = XML_SA.nouveauDocument();

    // Si nous avons cr le document XML avec createDocument, utiliser
    // onload pour dterminer la fin de son tlchargement.
    if (document.implementation && document.implementation.createDocument) {
        docXML.onload = function() { rappel(docXML); };
    }
    // Sinon, utiliser onreadystatechange, comme pour XMLHttpRequest.
    else {
        docXML.onreadystatechange = function() {
            if (docXML.readyState == 4) rappel(docXML);
        };
    }

    // Dmarrer le tlchargement et linterprtation.
    docXML.load(url);
};

/**
 * Analyser le document XML contenu dans la chane passe en argument et
 * retourner un objet Document qui le reprsente.
 */
XML_SA.analyser = function(texte) {
    if (typeof DOMParser != "undefined") {
        // Mozilla, Firefox et navigateurs connexes.
        return (new DOMParser()).parseFromString(texte, "application/xml");
    }
    else if (typeof ActiveXObject != "undefined") {
        // Internet Explorer.
        var doc = XML_SA.nouveauDocument();  // Crer un document vide.
        doc.loadXML(texte);               // Y placer le texte trait.
        return doc;                       // Le retourner.
    }
    else {
        // En dernier ressort, tenter de tlcharger le document depuis
        // une URL data:. Cela semble fonctionner dans Safari. Merci
        //  Manos Batsis et  sa bibliothque Sarissa
        // (sarissa.sourceforge.net) pour cette technique.
        var url = "data:text/xml;charset=utf-8," + encodeURIComponent(texte);
        var requete = new XMLHttpRequest();
        requete.open("GET", url, false);
        requete.send(null);
        return requete.responseXML;
    }
};

/**
 * Retourner un objet Document dans lequel est plac le contenu de la balise
 * <xml> ayant lidentifiant prcis. Si cette balise possde un attribut src,
 * le document XML est charg depuis lURL correspondante.
 *
 * Puisque les lots de donnes sont, en gnral, consults plus dune fois,
 * cette fonction place en cache le document retourn.
 */
XML_SA.obtenirIlotDonnees = function(id) {
    var doc;

    // Commencer par consulter le cache.
    doc = XML_SA.obtenirIlotDonnees.cache[id];
    if (doc) return doc;
    
    // Rechercher llment dsign.
    doc = document.getElementById(id);

    // Sil possde un attribut "src", rcuprer le document depuis
    // lURL correspondante.
    var url = doc.getAttribute('src');
    if (url) {
        doc = XML_SA.charger(url);
    }
    // Sinon, le contenu de la balise <xml> correspond au document que 
    // nous voulons retourner. Dans Internet Explorer, doc est dj lobjet
    // Document recherch. Dans les autres navigateurs, doc fait rfrence
    //  un lment HTML et nous devons copier son contenu dans un nouvel
    // objet Document.
    else if (!doc.documentElement) {// Si ce nest pas dj un document...

        // Trouver llment de document dans la balise <xml>. Il sagit
        // du premier enfant de la balise <xml> qui est galement un lment,
        // et non du texte, un commentaire ou une instruction de traitement.
        var elementDoc = doc.firstChild;
        while(elementDoc != null) {
            if (elementDoc.nodeType == 1 /*Node.ELEMENT_NODE*/) break;
            elementDoc = elementDoc.nextSibling;
        }
        
        // Crer un document vide.
        doc = XML_SA.nouveauDocument();
        
        // Si le nud <xml> a du contenu, limporter dans le nouveau document.
        if (elementDoc) doc.appendChild(doc.importNode(elementDoc, true));
    }

    // Placer le document dans le cache, puis le retourner.
    XML_SA.obtenirIlotDonnees.cache[id] = doc;
    return doc;
};

XML_SA.obtenirIlotDonnees.cache = {}; // Initialiser le cache.

/**
 * Cette classe XML_SA.Transformateur encapsule une feuille de style XSL. Si
 * le paramtre feuilleDeStyle est une URL, nous la chargeons. Sinon, nous
 * supposons quil contient un objet DOM Document appropri.
 */
XML_SA.Transformateur = function(feuilleDeStyle) {
    // Si ncessaire, charger la feuille de style.
    if (typeof feuilleDeStyle == "string")
        feuilleDeStyle = XML_SA.load(feuilleDeStyle);
    this.feuilleDeStyle = feuilleDeStyle;

    // Dans les navigateurs de type Mozilla, crer un objet XSLTProcessor
    // et lui passer la feuille de style.
    if (typeof XSLTProcessor != "undefined") {
        this.processor = new XSLTProcessor();
        this.processor.importStylesheet(this.feuilleDeStyle);
    }
};

/**
 * Voici la mthode transformer() de la classe XML_SA.Transformateur. Elle
 * transforme le nud XML indiqu en utilisant la feuille de style
 * encapsule. On suppose que le rsultat de la transformation est du
 * HTML et on lutilise pour remplacer le contenu de llment indiqu.
 */
XML_SA.Transformateur.prototype.transformer = function(noeud, element) {
    // Si llment est indiqu par son identifiant, le rechercher.
    if (typeof element == "string") element = document.getElementById(element);

    if (this.processor) {
        // Si nous avons cr un XSLTProcessor (cest--dire, nous sommes
        // dans Mozilla), lutiliser. Transformer le nud en un objet
        // DOM DocumentFragment.
        var fragment = this.processor.transformToFragment(noeud, document);
        // Effacer le contenu existant de llment.
        element.innerHTML = "";
        // Insrer les nuds transforms.
        element.appendChild(fragment);
    }
    else if ("transformNode" in noeud) {
        // Si le nud possde une fonction transformNode() (dans IE),
        // lutiliser. Notez quelle retourne une chane de caractres.
        element.innerHTML = noeud.transformNode(this.feuilleDeStyle);
    }
    else {
        // Sinon, nous ne pouvons rien faire.
        throw "Ce navigateur ne prend pas en charge XSLT.";
    }
};

/**
 * Fonction utile lorsquune feuille de style nest utilise 
 * quune seule fois.
 */
XML_SA.transformer = function(docXML, feuilleDeStyle, element) {
    var transformateur = new XML_SA.Transformateur(feuilleDeStyle);
    transformateur.transformer(docXML, element);
}

/**
 * La classe XML_SA.ExpressionXPath encapsule une requte XPath et sa
 * correspondance entre le prfixe despaces de noms et lURL. Une fois
 * lobjet XML_SA.ExpressionXPath cr, il peut tre valu une ou plusieurs
 * fois (dans un ou plusieurs contextes)  laide des mthodes obtenirNoeud()
 * ou obtenirNoeuds().
 *
 * Ce constructeur prend en premier argument le texte de lexpression XPath.
 * 
 * Si lexpression inclut des espaces de noms XML, le second argument doit
 * tre un objet JavaScript qui associe les prfixes despaces de noms
 * aux URL qui dfinissent ces espaces. Les proprits de cet objet sont
 * les prfixes, leurs valeurs sont les URL.
 */
XML_SA.ExpressionXPath = function(texteXPath, espacesDeNoms) {
    this.texteXPath = texteXPath;        // Mmoriser lexpression.
    this.espacesDeNoms = espacesDeNoms;  // Et les associations despaces 
                                         // de noms.

    if (document.createExpression) {
        // Si le navigateur est conforme au W3C, utiliser lAPI du W3C
        // pour compiler le texte de la requte XPath.
        this.exprXPath = 
            document.createExpression(texteXPath, 
                                      // Cette fonction reoit en argument
                                      // un prfixe despaces de noms et
                                      // retourne lURL.
                                      function(prefixe) {
                                          return espacesDeNoms[prefixe];
                                      });
    }
    else {
        // Sinon, nous supposons pour le moment que nous sommes dans IE
        // et transformons lobjet espacesDeNoms sous la forme textuelle
        // requise par Internet Explorer.
        this.chaineEspaceDeNoms = "";
        if (espacesDeNoms != null) {
            for(var prefixe in espacesDeNoms) {
                // Ajouter un espace si la chane nest pas vide.
                if (this.chaineEspaceDeNoms) this.chaineEspaceDeNoms += ' ';
                // Puis, ajouter lespace de noms.
                this.chaineEspaceDeNoms += 'xmlns:' + prefixe + '="' +
                    espacesDeNoms[prefixe] + '"';
            }
        }
    }
};

/**
 * Voici la mthode obtenirNoeuds() de XML_SA.ExpressionXPath. Elle value
 * lexpression XPath dans le contexte indiqu. Largument contexte doit 
 * tre un objet Document ou Element. La valeur de retour est un tableau 
 * ou un objet de type tableau qui contient les nuds correspondant 
 * lexpression.
 */
XML_SA.ExpressionXPath.prototype.obtenirNoeuds = function(contexte) {
    if (this.exprXPath) {
        // Si nous sommes dans un navigateur conforme au W3C, nous avons
        // compil lexpression dans le constructeur. Nous valuons
        // maintenant cette version compile dans le contexte indiqu.
        var resultat =
            this.exprXPath.evaluate(contexte, 
                                    // Type du rsultat attendu.
                                    XPathResult.ORDERED_NODE_SNAPSHOT_TYPE,
                                    null);

        // Copier le rsultat dans un tableau.
        var a = new Array(resultat.snapshotLength);
        for(var i = 0; i < resultat.snapshotLength; i++) {
            a[i] = resultat.snapshotItem(i);
        }
        return a;
    }
    else {
        // Si le navigateur nest pas conforme au W3C, tenter dvaluer
        // lexpression en utilisant lAPI dInternet Explorer.
        try {
            // Nous avons besoin de lobjet Document pour prciser
            // lespace de noms.
            var doc = contexte.ownerDocument;
            // Si le contexte ne contient pas ownerDocument, il sagit 
            // du document.
            if (doc == null) doc = contexte;
            // Technique propre  IE pour spcifier la correspondance 
            // entre les prfixes et les URL.
            doc.setProperty("SelectionLanguage", "XPath");
            doc.setProperty("SelectionNamespaces", this.chaineEspaceDeNoms);

            // Dans IE, le contexte doit tre un Element, non un Document.
            // Sil est un document, utiliser  la place documentElement.
            if (contexte == doc) contexte = doc.documentElement;
            // Utiliser la mthode selectNodes() dIE pour
            // valuer lexpression.
            return contexte.selectNodes(this.texteXPath);
        }
        catch(e) {
            // Si lAPI dIE ne fonctionne pas, arrter tout.
            throw "Ce navigateur ne prend pas en charge XPath.";
        }
    }
}

/**
 * Voici la mthode obtenirNoeud() de XML_SA.ExpressionXPath. Elle value
 * lexpression XPath dans le contexte indiqu et retourne un seul nud
 * correspondant (ou null si aucun nud ne correspond). Si plusieurs nuds
 * correspondent, elle retourne le premier nud du document. Limplmentation
 * diffre de la mthode obtenirNoeuds() uniquement par le type de retour.
 */
XML_SA.ExpressionXPath.prototype.obtenirNoeud = function(contexte) {
    if (this.exprXPath) {
        var resultat =
            this.exprXPath.evaluate(contexte, 
                                    // Nous voulons uniquement la premire
                                    // correspondance.
                                    XPathResult.FIRST_ORDERED_NODE_TYPE,
                                    null);
        return resultat.singleNodeValue;
    }
    else {
        try {
            var doc = contexte.ownerDocument;
            if (doc == null) doc = contexte;
            doc.setProperty("SelectionLanguage", "XPath");
            doc.setProperty("SelectionNamespaces", this.chaineEspaceDeNoms);
            if (contexte == doc) contexte = doc.documentElement;
            // Dans IE, appeler selectSingleNode()  la place
            // de selectNodes().
            return contexte.selectSingleNode(this.texteXPath);
        }
        catch(e) {
            throw "Ce navigateur ne prend pas en charge XPath.";
        }
    }
};

// Fonction utilitaire pour crer un objet XML_SA.ExpressionXPath et 
// appeler obtenirNoeuds().
XML_SA.obtenirNoeuds = function(contexte, exprXPath, espacesDeNoms) {
    return (new XML_SA.ExpressionXPath(exprXPath, 
                                    espacesDeNoms)).obtenirNoeuds(contexte);
};

// Fonction utilitaire pour crer un objet XML_SA.ExpressionXPath et 
// appeler obtenirNoeud().
XML_SA.obtenirNoeud  = function(contexte, exprXPath, espacesDeNoms) {
    return (new XML_SA.ExpressionXPath(exprXPath,
                                    espacesDeNoms)).obtenirNoeud(contexte);
};

/**
 * Srialiser un Document ou un Element XML et le retourner sous forme
 * dune chane de caractres.
 */
XML_SA.serialiser = function(noeud) {
    if (typeof XMLSerializer != "undefined")
        return (new XMLSerializer()).serializeToString(noeud);
    else if (noeud.xml) return noeud.xml;
    else 
        throw "XML_SA.serialiser nest pas prise en charge ou ne peut srialiser "
           + noeud;
};

/*
 * Dvelopper tous les modles se trouvant  ou sous llment e. Si un
 * modle utilise des expressions XPath avec un espace de noms, passer la
 * correspondance entre un prfixe et une URL en second argument, comme
 * pour XML_SA.ExpressionXPath().
 * 
 * Si e nest pas spcifi, document.body est utilis  la place. Cette
 * fonction sera le plus souvent invoque sans argument, en rponse 
 * un gestionnaire dvnements onload. Cela permet de dvelopper
 * automatiquement tous les modles.
 */
XML_SA.developperModeles = function(e, espacesDeNoms) {
    // Adapter les arguments.
    if (!e) e = document.body;
    else if (typeof e == "string") e = document.getElementById(e);
    if (!espacesDeNoms) espacesDeNoms = null; // "undefined" ne fonctionne pas.

    // Un lment HTML est un modle sil possde un attribut "datasource".
    // Rechercher et dvelopper rcursivement tous les modles. Noter que 
    // les modles imbriqus ne sont pas accepts.
    if (e.getAttribute("datasource")) {
        // Sil sagit dun modle, le dvelopper.
        XML_SA.developperModele(e, espacesDeNoms);
    }
    else {
        // Sinon, parcourir rcursivement chaque enfant. Nous effectuons tout
        // dabord une copie statique de lenfant afin que le dveloppement
        // dun modle ne perturbe pas litration.
        var enfants = []; // Pour les copies des lments enfants.
        for(var i = 0; i < e.childNodes.length; i++) {
            var c = e.childNodes[i];
            if (c.nodeType == 1) enfants.push(e.childNodes[i]);
        }
        
        // Parcourir chaque lment enfant.
        for(var i = 0; i < enfants.length; i++)
            XML_SA.developperModeles(enfants[i], espacesDeNoms);
    }
};

/**
 * Dvelopper le modle indiqu. Si les expressions XPath du modle
 * utilisent un espace de noms, le deuxime argument doit spcifier
 * la correspondance entre le prfixe et lURL.
 */
XML_SA.developperModele = function(modele, espacesDeNoms) {
    if (typeof modele=="string") modele=document.getElementById(modele);
    if (!espacesDeNoms) espacesDeNoms = null; // "undefined" ne fonctionne pas.

    // Nous devons commencer par dterminer la provenance 
    // des donnes du modle.
    var sourceDonnees = modele.getAttribute("datasource");

    // Si la valeur de lattribut datasource commence par '#', elle 
    // indique le nom dun lot de donnes XML. Sinon, il sagit de lURL 
    // dun fichier XML externe.
    var docDonnees;
    if (sourceDonnees.charAt(0) == '#')   // Obtenir llot de donnes.
        docDonnees = XML_SA.obtenirIlotDonnees(sourceDonnees.substring(1));
    else                                  // Ou charger le document externe.
        docDonnees = XML_SA.load(sourceDonnees);

    // Dterminer les nuds de la source de donnes qui fourniront 
    // les donnes. Si le modle possde un attribut foreach, 
    // nous lutilisons comme une expression XPath pour obtenir
    // la liste des nuds. Sinon, nous utilisons tous les lments
    // enfants de llment Document.
    var noeudsDonnees;
    var pourChaque = template.getAttribute("foreach");
    if (pourChaque)
        noeudsDonnees = XML_SA.obtenirNoeuds(docDonnees, pourChaque,
                                          espacesDeNoms);
    else {
        // Si lattribut foreach nest pas prsent, utiliser llment
        // enfant de documentElement.
        noeudsDonnees = [];
        for(var c=docDonnees.documentElement.firstChild; c!=null;
            c=c.nextSibling)
            if (c.nodeType == 1) noeudsDonnees.push(c);
    }

    // Retirer llment modle de son parent, mais mmoriser ce dernier, 
    // ainsi que le frre suivant du modle.
    var conteneur = modele.parentNode;
    var pointInsertion = modele.nextSibling;
    modele = conteneur.removeChild(modele);

    // Pour chaque lment du tableau noeudsDonnees, nous allons insrer
    // une copie du modle dans le conteneur. Mais avant deffectuer cette
    // opration, nous dveloppons tout enfant dans la copie possdant
    // lattribut data.
    for(var i = 0; i < noeudsDonnees.length; i++) {
        var copie = modele.cloneNode(true);            // Copier le modle.
        developper(copie, noeudsDonnees[i],            // Dvelopper la copie.
                   espacesDeNoms); 
        conteneur.insertBefore(copie, pointInsertion); // Insrer la copie.
    }

    // Cette fonction imbrique trouve tous les lments enfants de e qui
    // possdent un attribut data. Elle traite cet attribut comme une
    // expression XPath quelle value dans le contexte de noeudDonnees.
    // Elle prend la valeur textuelle du rsultat de lvaluation et en
    // fait le contenu du nud HTML en cours de traitement. Tout autre
    // contenu est supprim.
    function developper(e, noeudDonnees, espacesDeNoms) {
        for(var c = e.firstChild; c != null; c = c.nextSibling) {
            if (c.nodeType != 1) continue;  // Uniquement les lments.
            var exprDonnees = c.getAttribute("data");
            if (exprDonnees) {
                // valuer lexpression XPath dans le contexte.
                var n = XML_SA.obtenirNoeud(noeudDonnees, exprDonnees,
                                         espacesDeNoms);
                // Supprimer tout contenu de llment.
                c.innerHTML = "";
                // Insrer le texte du rsultat de lvaluation XPath.
                c.appendChild(document.createTextNode(obtenirTexte(n)));
            }
            // Si nous ne dveloppons pas le nud, parcourir sa hirarchie.
            else developper(c, noeudDonnees, espacesDeNoms);
        }
    }

    // Cette fonction imbrique extrait le texte dun nud DOM, avec
    // un parcours rcursif si ncessaire.
    function obtenirTexte(n) {
        switch(n.nodeType) {
        case 1: /* lment */
            var s = "";
            for(var c = n.firstChild; c != null; c = c.nextSibling)
                s += obtenirTexte(c);
            return s;
        case 2: /* attribut */
        case 3: /* texte */
        case 4: /* cdata */
            return n.nodeValue;
        default: 
            return "";
        }
    }
    
};
